/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;
import schemacrawler.inclusionrule.ExcludeAll;
import schemacrawler.inclusionrule.IncludeAll;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.inclusionrule.InclusionRuleWithRegularExpression;
import schemacrawler.schema.RoutineType;
import schemacrawler.schema.TableTypes;
import schemacrawler.schemacrawler.DatabaseObjectRuleForInclusion;
import schemacrawler.schemacrawler.Options;

public record LimitOptions(@NonNull Map<DatabaseObjectRuleForInclusion, InclusionRule> inclusionRules, @NonNull TableTypes tableTypes, @Nullable String tableNamePattern, @NonNull EnumSet<RoutineType> routineTypes) implements Options
{
    private final @NonNull EnumSet<RoutineType> routineTypes;

    public LimitOptions(@NonNull Map<DatabaseObjectRuleForInclusion, InclusionRule> inclusionRules, @NonNull TableTypes tableTypes, @Nullable String tableNamePattern, @NonNull EnumSet<RoutineType> routineTypes) {
        Objects.requireNonNull(inclusionRules, "No inclusion rules provided");
        inclusionRules = new EnumMap<DatabaseObjectRuleForInclusion, InclusionRule>(inclusionRules);
        tableTypes = Objects.requireNonNull(tableTypes, "No table types provided");
        Objects.requireNonNull(routineTypes, "No routine types provided");
        routineTypes = EnumSet.copyOf(routineTypes);
    }

    public InclusionRule get(DatabaseObjectRuleForInclusion inclusionRuleKey) {
        InclusionRuleWithRegularExpression defaultInclusionRule = inclusionRuleKey.isExcludeByDefault() ? new ExcludeAll() : new IncludeAll();
        return this.inclusionRules.getOrDefault((Object)inclusionRuleKey, defaultInclusionRule);
    }

    public EnumSet<RoutineType> routineTypes() {
        return EnumSet.copyOf(this.routineTypes);
    }

    public boolean isExcludeAll(DatabaseObjectRuleForInclusion inclusionRuleKey) {
        return this.get(inclusionRuleKey).equals(new ExcludeAll());
    }

    public boolean isIncludeAll(DatabaseObjectRuleForInclusion inclusionRuleKey) {
        return this.get(inclusionRuleKey).equals(new IncludeAll());
    }
}

