/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.regex.tregex.automaton.TransitionConstraint;
import com.oracle.truffle.regex.tregex.nodes.dfa.CounterTracker;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.Matchers;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;

public class DFABQTrackingStateNode
extends DFAStateNode {
    @CompilerDirectives.CompilationFinal(dimensions=2)
    private final long[][] unAnchoredFinalConstraints;
    @CompilerDirectives.CompilationFinal(dimensions=2)
    private final long[][] anchoredFinalConstraints;

    public DFABQTrackingStateNode(short id, byte flags, short loopTransitionIndex, short indexOfNodeId, byte indexOfIsFast, short[] successors, Matchers matchers, long[][] unAnchoredFinalConstraints, long[][] anchoredFinalConstraints) {
        super(id, flags, loopTransitionIndex, indexOfNodeId, indexOfIsFast, successors, matchers, (short)-1);
        this.unAnchoredFinalConstraints = unAnchoredFinalConstraints;
        this.anchoredFinalConstraints = anchoredFinalConstraints;
    }

    @Override
    @ExplodeLoop
    boolean checkFinalState(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        CompilerAsserts.partialEvaluationConstant((Object)((Object)executor));
        if (this.isFinalState()) {
            this.storeResult(locals, executor, false);
            return true;
        }
        if (this.isGuardedFinalState()) {
            for (long[] cs : this.unAnchoredFinalConstraints) {
                assert (cs.length > 0);
                if (!DFABQTrackingStateNode.constraintsAreSatisfied(locals, executor, cs)) continue;
                this.storeResult(locals, executor, false);
                return true;
            }
        }
        return false;
    }

    @Override
    @ExplodeLoop
    void atEnd(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, boolean inputAtEnd) {
        boolean guardedAnchored;
        CompilerAsserts.partialEvaluationConstant((Object)this);
        CompilerAsserts.partialEvaluationConstant((Object)((Object)executor));
        super.atEnd(locals, executor, inputAtEnd);
        boolean bl = guardedAnchored = this.isGuardedAnchoredFinalState() && inputAtEnd;
        if (this.isGuardedFinalState()) {
            for (long[] cs : this.unAnchoredFinalConstraints) {
                if (!DFABQTrackingStateNode.constraintsAreSatisfied(locals, executor, cs)) continue;
                this.storeResult(locals, executor, false);
                return;
            }
        }
        if (guardedAnchored) {
            for (long[] cs : this.anchoredFinalConstraints) {
                if (!DFABQTrackingStateNode.constraintsAreSatisfied(locals, executor, cs)) continue;
                this.storeResult(locals, executor, true);
                return;
            }
        }
    }

    @ExplodeLoop
    private static boolean constraintsAreSatisfied(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, long[] constraints) {
        CompilerAsserts.partialEvaluationConstant((Object)((Object)executor));
        CompilerAsserts.partialEvaluationConstant((Object)constraints);
        for (long constraint : constraints) {
            int qId = TransitionConstraint.getQuantifierID(constraint);
            CompilerAsserts.partialEvaluationConstant((long)constraint);
            CompilerAsserts.partialEvaluationConstant((int)qId);
            CounterTracker counterTracker = executor.getCounterTrackers()[qId];
            CompilerAsserts.partialEvaluationConstant((Object)counterTracker);
            if (counterTracker.canExecute(constraint, locals.getFixedData(), locals.getIntArrays())) continue;
            return false;
        }
        return true;
    }
}

