/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import schemacrawler.crawl.ResultsRetriever;
import schemacrawler.schema.ResultsColumns;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;

public final class ResultsCrawler {
    private final ResultSet results;

    public ResultsCrawler(ResultSet results) {
        this.results = Objects.requireNonNull(results, "No result-set specified");
    }

    public ResultsColumns crawl() throws SQLException {
        try {
            ResultsRetriever resultsRetriever = new ResultsRetriever(this.results);
            ResultsColumns resultsColumns = resultsRetriever.retrieveResults();
            return resultsColumns;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecutionRuntimeException("Could not retrieve result-set metadata", e);
        }
    }
}

