/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGCSupportFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import java.util.logging.Level;

public abstract class CApiGCSupport {
    public static final CApiTiming VISIT_TIMING = CApiTiming.create(true, ExternalFunctionNodes.PExternalFunctionWrapper.VISITPROC);
    public static final long NEXT_MASK_UNREACHABLE = 1L;
    private static final long _PyGC_PREV_MASK_FINALIZED = 1L;
    private static final long _PyGC_PREV_SHIFT = 2L;
    private static final long _PyGC_PREV_MASK = -4L;

    private CApiGCSupport() {
    }

    static long maskPrevValue(long value) {
        return value & 0xFFFFFFFFFFFFFFFCL;
    }

    static long computePrevValue(long curPrevValue, long newValue) {
        assert ((newValue & 3L) == 0L);
        return curPrevValue & 3L | newValue;
    }

    @GenerateInline
    @GenerateUncached
    @GenerateCached(value=false)
    public static abstract class PyObjectGCDelNode
    extends Node {
        public static void executeUncached(long op) {
            CApiGCSupportFactory.PyObjectGCDelNodeGen.getUncached().execute(null, op);
        }

        public abstract void execute(Node var1, long var2);

        @Specialization
        static void doGeneric(Node inliningTarget, long op, @Cached GCListRemoveNode gcListRemoveNode, @Cached(inline=false) CStructAccess.GetElementPtrNode getElementPtrNode, @Cached(inline=false) CStructAccess.ReadI32Node readI32Node, @Cached(inline=false) CStructAccess.WriteIntNode writeIntNode) {
            if (CApiContext.GC_LOGGER.isLoggable(Level.FINE)) {
                CApiContext.GC_LOGGER.fine(PythonUtils.formatJString("releasing native object stub 0x%x", op));
            }
            assert (CApiTransitions.HandlePointerConverter.pointsToPyHandleSpace(op)) : "expected tagged pointer";
            long opUntagged = CApiTransitions.HandlePointerConverter.pointerToStub(op);
            long gcUntagged = gcListRemoveNode.execute(inliningTarget, opUntagged);
            Object gcState = PythonContext.get(inliningTarget).getCApiContext().getGCState();
            assert (gcState != null);
            Object generations = getElementPtrNode.getElementPtr(gcState, CFields.GCState__generations);
            int count = readI32Node.read(generations, CFields.GCGeneration__count);
            if (count > 0) {
                writeIntNode.write(generations, CFields.GCGeneration__count, count - 1);
            }
            CStructAccess.FreeNode.executeUncached(gcUntagged);
        }
    }

    @GenerateInline
    @GenerateUncached
    @GenerateCached(value=false)
    public static abstract class GCListRemoveNode
    extends Node {
        public static long executeUncached(long opUntagged) {
            return CApiGCSupportFactory.GCListRemoveNodeGen.getUncached().execute(null, opUntagged);
        }

        public abstract long execute(Node var1, long var2);

        @Specialization
        static long doGeneric(long opUntagged, @Cached(inline=false) CStructAccess.ReadI64Node readI64Node, @Cached(inline=false) CStructAccess.WriteLongNode writeLongNode) {
            if (CApiContext.GC_LOGGER.isLoggable(Level.FINER)) {
                CApiContext.GC_LOGGER.finer(PythonUtils.formatJString("attempting to remove 0x%x from GC generation", opUntagged));
            }
            assert (!CApiTransitions.HandlePointerConverter.pointsToPyHandleSpace(opUntagged)) : "expected real (untagged) pointer";
            long gcUntagged = opUntagged - (long)CStructs.PyGC_Head.size();
            long gcNext = readI64Node.read(gcUntagged, CFields.PyGC_Head___gc_next);
            if (gcNext != 0L) {
                if (CApiContext.GC_LOGGER.isLoggable(Level.FINE)) {
                    CApiContext.GC_LOGGER.fine(PythonUtils.formatJString("removing 0x%x from GC generation", opUntagged));
                }
                long prev = CApiGCSupport.maskPrevValue(readI64Node.read(gcUntagged, CFields.PyGC_Head___gc_prev));
                long next = readI64Node.read(gcUntagged, CFields.PyGC_Head___gc_next);
                writeLongNode.write(CApiTransitions.HandlePointerConverter.pointerToStub(prev), CFields.PyGC_Head___gc_next, next);
                long curNextPrev = readI64Node.read(CApiTransitions.HandlePointerConverter.pointerToStub(next), CFields.PyGC_Head___gc_prev);
                writeLongNode.write(CApiTransitions.HandlePointerConverter.pointerToStub(next), CFields.PyGC_Head___gc_prev, CApiGCSupport.computePrevValue(curNextPrev, prev));
                writeLongNode.write(gcUntagged, CFields.PyGC_Head___gc_next, 0L);
            } else if (CApiContext.GC_LOGGER.isLoggable(Level.FINER)) {
                CApiContext.GC_LOGGER.finer(PythonUtils.formatJString("removing 0x%x from GC generation skipped; not tracked", opUntagged));
            }
            return gcUntagged;
        }
    }

    @GenerateInline
    @GenerateUncached
    @GenerateCached(value=false)
    public static abstract class PyObjectGCTrackNode
    extends Node {
        public abstract void execute(Node var1, long var2);

        @Specialization
        static void doGeneric(Node inliningTarget, long gc, @Cached CExtCommonNodes.CoerceNativePointerToLongNode coerceToLongNode, @Cached(inline=false) CStructAccess.ReadPointerNode readPointerNode, @Cached(inline=false) CStructAccess.ReadI64Node readI64Node, @Cached(inline=false) CStructAccess.WriteLongNode writeLongNode) {
            long gcUntagged = CApiTransitions.HandlePointerConverter.pointerToStub(gc);
            long gcNext = readI64Node.read(gcUntagged, CFields.PyGC_Head___gc_next);
            if (gcNext == 0L) {
                if (CApiContext.GC_LOGGER.isLoggable(Level.FINER)) {
                    CApiContext.GC_LOGGER.finer(PythonUtils.formatJString("tracking GC object 0x%x (op=0x%x)", gc, gc + (long)CStructs.PyGC_Head.size()));
                }
                Object gcState = PythonContext.get(inliningTarget).getCApiContext().getGCState();
                assert (gcState != null);
                long gen0 = coerceToLongNode.execute(inliningTarget, readPointerNode.read(gcState, CFields.GCState__generation0));
                assert (gen0 != 0L);
                assert (!CApiTransitions.HandlePointerConverter.pointsToPyHandleSpace(gen0));
                long last = readI64Node.read(gen0, CFields.PyGC_Head___gc_prev);
                writeLongNode.write(CApiTransitions.HandlePointerConverter.pointerToStub(last), CFields.PyGC_Head___gc_next, gc);
                long curGcPrev = readI64Node.read(gcUntagged, CFields.PyGC_Head___gc_prev);
                writeLongNode.write(gcUntagged, CFields.PyGC_Head___gc_prev, CApiGCSupport.computePrevValue(curGcPrev, last));
                writeLongNode.write(gcUntagged, CFields.PyGC_Head___gc_next, gen0);
                writeLongNode.write(gen0, CFields.PyGC_Head___gc_prev, gc);
            } else if (CApiContext.GC_LOGGER.isLoggable(Level.FINER)) {
                CApiContext.GC_LOGGER.finer(PythonUtils.formatJString("GC object 0x%x (op=0x%x) already tracked", gc, gc + (long)CStructs.PyGC_Head.size()));
            }
        }
    }
}

