/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.utility;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import schemacrawler.schemacrawler.exceptions.InternalRuntimeException;
import schemacrawler.tools.databaseconnector.DatabaseConnector;
import schemacrawler.tools.databaseconnector.DatabaseConnectorRegistry;
import schemacrawler.tools.databaseconnector.UnknownDatabaseConnector;
import us.fatehi.utility.Utility;
import us.fatehi.utility.datasource.DatabaseServerType;
import us.fatehi.utility.readconfig.SystemPropertiesConfig;

public final class DatabaseConnectorUtility {
    private static final Logger LOGGER = Logger.getLogger(DatabaseConnectorUtility.class.getName());

    public static DatabaseConnector findDatabaseConnector(Connection connection) {
        Objects.requireNonNull(connection, "No database connection provided");
        DatabaseConnectorRegistry registry = DatabaseConnectorRegistry.getDatabaseConnectorRegistry();
        DatabaseConnector dbConnector = registry.findDatabaseConnector(connection);
        DatabaseServerType databaseServerType = dbConnector.getDatabaseServerType();
        if (databaseServerType.isUnknownDatabaseSystem()) {
            LOGGER.log(Level.INFO, "Not using any SchemaCrawler database plugin");
        } else {
            LOGGER.log(Level.INFO, "Using SchemaCrawler database plugin for " + String.valueOf(databaseServerType));
        }
        String url = DatabaseConnectorUtility.getConnectionUrl(connection);
        if (Utility.isBlank(url)) {
            return dbConnector;
        }
        boolean useMatchedDatabasePlugin = DatabaseConnectorUtility.useMatchedDatabasePlugin(url, databaseServerType);
        if (!useMatchedDatabasePlugin) {
            dbConnector = UnknownDatabaseConnector.UNKNOWN;
        }
        return dbConnector;
    }

    private static String extractDatabaseServerTypeFromUrl(String url) {
        String urlDBServerType;
        Pattern urlPattern = Pattern.compile("jdbc:(.*?):.*");
        Matcher matcher = urlPattern.matcher(url);
        if (!matcher.matches()) {
            return "";
        }
        if (matcher.groupCount() == 1) {
            String matchedDBServerType = matcher.group(1);
            urlDBServerType = List.of("db2", "hsqldb", "mariadb", "mysql", "oracle", "postgresql", "sqlite", "sqlserver").contains(matchedDBServerType) ? matchedDBServerType : null;
        } else {
            urlDBServerType = null;
        }
        if (Utility.isBlank(urlDBServerType)) {
            return "";
        }
        if ("mariadb".equals(urlDBServerType)) {
            return "mysql";
        }
        return urlDBServerType;
    }

    private static String getConnectionUrl(Connection connection) {
        String url;
        Objects.requireNonNull(connection, "No connection provided");
        try {
            url = connection.getMetaData().getURL();
        }
        catch (SQLException e) {
            LOGGER.log(Level.CONFIG, "Cannot get connection URL");
            return "";
        }
        return url;
    }

    private static boolean useMatchedDatabasePlugin(String url, DatabaseServerType dbServerType) {
        String urlDBServerType = DatabaseConnectorUtility.extractDatabaseServerTypeFromUrl(url);
        if (Utility.isBlank(urlDBServerType)) {
            return true;
        }
        boolean dbConnectorPresent = urlDBServerType.equalsIgnoreCase(dbServerType.getDatabaseSystemIdentifier());
        String withoutDatabasePlugin = new SystemPropertiesConfig().getStringValue("SC_WITHOUT_DATABASE_PLUGIN");
        boolean useWithoutDatabasePlugin = urlDBServerType.equalsIgnoreCase(withoutDatabasePlugin);
        if (!dbConnectorPresent && !useWithoutDatabasePlugin) {
            throw new InternalRuntimeException("Add the SchemaCrawler database plugin for <%s> to the CLASSPATH for\n%s\nor set\nSC_WITHOUT_DATABASE_PLUGIN=%s\neither as an environmental variable or as a Java system property\n".formatted(urlDBServerType, url, urlDBServerType));
        }
        boolean useMatchedDatabasePlugin = dbConnectorPresent && !useWithoutDatabasePlugin;
        return useMatchedDatabasePlugin;
    }

    private DatabaseConnectorUtility() {
    }
}

