﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/appsync/AppSyncRequest.h>
#include <aws/appsync/AppSync_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace AppSync {
namespace Model {

/**
 */
class DisassociateMergedGraphqlApiRequest : public AppSyncRequest {
 public:
  AWS_APPSYNC_API DisassociateMergedGraphqlApiRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DisassociateMergedGraphqlApi"; }

  AWS_APPSYNC_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The identifier of the AppSync Source API. This is generated by the AppSync
   * service. In most cases, source APIs (especially in your account) only require
   * the API ID value or ARN of the source API. However, source APIs from other
   * accounts (cross-account use cases) strictly require the full resource ARN of the
   * source API.</p>
   */
  inline const Aws::String& GetSourceApiIdentifier() const { return m_sourceApiIdentifier; }
  inline bool SourceApiIdentifierHasBeenSet() const { return m_sourceApiIdentifierHasBeenSet; }
  template <typename SourceApiIdentifierT = Aws::String>
  void SetSourceApiIdentifier(SourceApiIdentifierT&& value) {
    m_sourceApiIdentifierHasBeenSet = true;
    m_sourceApiIdentifier = std::forward<SourceApiIdentifierT>(value);
  }
  template <typename SourceApiIdentifierT = Aws::String>
  DisassociateMergedGraphqlApiRequest& WithSourceApiIdentifier(SourceApiIdentifierT&& value) {
    SetSourceApiIdentifier(std::forward<SourceApiIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID generated by the AppSync service for the source API association.</p>
   */
  inline const Aws::String& GetAssociationId() const { return m_associationId; }
  inline bool AssociationIdHasBeenSet() const { return m_associationIdHasBeenSet; }
  template <typename AssociationIdT = Aws::String>
  void SetAssociationId(AssociationIdT&& value) {
    m_associationIdHasBeenSet = true;
    m_associationId = std::forward<AssociationIdT>(value);
  }
  template <typename AssociationIdT = Aws::String>
  DisassociateMergedGraphqlApiRequest& WithAssociationId(AssociationIdT&& value) {
    SetAssociationId(std::forward<AssociationIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_sourceApiIdentifier;
  bool m_sourceApiIdentifierHasBeenSet = false;

  Aws::String m_associationId;
  bool m_associationIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace AppSync
}  // namespace Aws
