﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/cleanrooms/CleanRoomsRequest.h>
#include <aws/cleanrooms/CleanRooms_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace CleanRooms {
namespace Model {

/**
 */
class GetProtectedQueryRequest : public CleanRoomsRequest {
 public:
  AWS_CLEANROOMS_API GetProtectedQueryRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetProtectedQuery"; }

  AWS_CLEANROOMS_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The identifier for a membership in a protected query instance.</p>
   */
  inline const Aws::String& GetMembershipIdentifier() const { return m_membershipIdentifier; }
  inline bool MembershipIdentifierHasBeenSet() const { return m_membershipIdentifierHasBeenSet; }
  template <typename MembershipIdentifierT = Aws::String>
  void SetMembershipIdentifier(MembershipIdentifierT&& value) {
    m_membershipIdentifierHasBeenSet = true;
    m_membershipIdentifier = std::forward<MembershipIdentifierT>(value);
  }
  template <typename MembershipIdentifierT = Aws::String>
  GetProtectedQueryRequest& WithMembershipIdentifier(MembershipIdentifierT&& value) {
    SetMembershipIdentifier(std::forward<MembershipIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The identifier for a protected query instance.</p>
   */
  inline const Aws::String& GetProtectedQueryIdentifier() const { return m_protectedQueryIdentifier; }
  inline bool ProtectedQueryIdentifierHasBeenSet() const { return m_protectedQueryIdentifierHasBeenSet; }
  template <typename ProtectedQueryIdentifierT = Aws::String>
  void SetProtectedQueryIdentifier(ProtectedQueryIdentifierT&& value) {
    m_protectedQueryIdentifierHasBeenSet = true;
    m_protectedQueryIdentifier = std::forward<ProtectedQueryIdentifierT>(value);
  }
  template <typename ProtectedQueryIdentifierT = Aws::String>
  GetProtectedQueryRequest& WithProtectedQueryIdentifier(ProtectedQueryIdentifierT&& value) {
    SetProtectedQueryIdentifier(std::forward<ProtectedQueryIdentifierT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_membershipIdentifier;
  bool m_membershipIdentifierHasBeenSet = false;

  Aws::String m_protectedQueryIdentifier;
  bool m_protectedQueryIdentifierHasBeenSet = false;
};

}  // namespace Model
}  // namespace CleanRooms
}  // namespace Aws
