﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codecommit/CodeCommit_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CodeCommit {
namespace Model {

/**
 * <p>Information about an update to the source branch of a pull
 * request.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/codecommit-2015-04-13/PullRequestSourceReferenceUpdatedEventMetadata">AWS
 * API Reference</a></p>
 */
class PullRequestSourceReferenceUpdatedEventMetadata {
 public:
  AWS_CODECOMMIT_API PullRequestSourceReferenceUpdatedEventMetadata() = default;
  AWS_CODECOMMIT_API PullRequestSourceReferenceUpdatedEventMetadata(Aws::Utils::Json::JsonView jsonValue);
  AWS_CODECOMMIT_API PullRequestSourceReferenceUpdatedEventMetadata& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CODECOMMIT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the repository where the pull request was updated.</p>
   */
  inline const Aws::String& GetRepositoryName() const { return m_repositoryName; }
  inline bool RepositoryNameHasBeenSet() const { return m_repositoryNameHasBeenSet; }
  template <typename RepositoryNameT = Aws::String>
  void SetRepositoryName(RepositoryNameT&& value) {
    m_repositoryNameHasBeenSet = true;
    m_repositoryName = std::forward<RepositoryNameT>(value);
  }
  template <typename RepositoryNameT = Aws::String>
  PullRequestSourceReferenceUpdatedEventMetadata& WithRepositoryName(RepositoryNameT&& value) {
    SetRepositoryName(std::forward<RepositoryNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The full commit ID of the commit in the destination branch that was the tip
   * of the branch at the time the pull request was updated.</p>
   */
  inline const Aws::String& GetBeforeCommitId() const { return m_beforeCommitId; }
  inline bool BeforeCommitIdHasBeenSet() const { return m_beforeCommitIdHasBeenSet; }
  template <typename BeforeCommitIdT = Aws::String>
  void SetBeforeCommitId(BeforeCommitIdT&& value) {
    m_beforeCommitIdHasBeenSet = true;
    m_beforeCommitId = std::forward<BeforeCommitIdT>(value);
  }
  template <typename BeforeCommitIdT = Aws::String>
  PullRequestSourceReferenceUpdatedEventMetadata& WithBeforeCommitId(BeforeCommitIdT&& value) {
    SetBeforeCommitId(std::forward<BeforeCommitIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The full commit ID of the commit in the source branch that was the tip of the
   * branch at the time the pull request was updated.</p>
   */
  inline const Aws::String& GetAfterCommitId() const { return m_afterCommitId; }
  inline bool AfterCommitIdHasBeenSet() const { return m_afterCommitIdHasBeenSet; }
  template <typename AfterCommitIdT = Aws::String>
  void SetAfterCommitId(AfterCommitIdT&& value) {
    m_afterCommitIdHasBeenSet = true;
    m_afterCommitId = std::forward<AfterCommitIdT>(value);
  }
  template <typename AfterCommitIdT = Aws::String>
  PullRequestSourceReferenceUpdatedEventMetadata& WithAfterCommitId(AfterCommitIdT&& value) {
    SetAfterCommitId(std::forward<AfterCommitIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The commit ID of the most recent commit that the source branch and the
   * destination branch have in common.</p>
   */
  inline const Aws::String& GetMergeBase() const { return m_mergeBase; }
  inline bool MergeBaseHasBeenSet() const { return m_mergeBaseHasBeenSet; }
  template <typename MergeBaseT = Aws::String>
  void SetMergeBase(MergeBaseT&& value) {
    m_mergeBaseHasBeenSet = true;
    m_mergeBase = std::forward<MergeBaseT>(value);
  }
  template <typename MergeBaseT = Aws::String>
  PullRequestSourceReferenceUpdatedEventMetadata& WithMergeBase(MergeBaseT&& value) {
    SetMergeBase(std::forward<MergeBaseT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_repositoryName;
  bool m_repositoryNameHasBeenSet = false;

  Aws::String m_beforeCommitId;
  bool m_beforeCommitIdHasBeenSet = false;

  Aws::String m_afterCommitId;
  bool m_afterCommitIdHasBeenSet = false;

  Aws::String m_mergeBase;
  bool m_mergeBaseHasBeenSet = false;
};

}  // namespace Model
}  // namespace CodeCommit
}  // namespace Aws
