﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/config/ConfigService_EXPORTS.h>
#include <aws/config/model/ConformancePackComplianceType.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace ConfigService {
namespace Model {

/**
 * <p>Filters the conformance packs based on an account ID, region, compliance
 * type, and the name of the conformance pack.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/AggregateConformancePackComplianceFilters">AWS
 * API Reference</a></p>
 */
class AggregateConformancePackComplianceFilters {
 public:
  AWS_CONFIGSERVICE_API AggregateConformancePackComplianceFilters() = default;
  AWS_CONFIGSERVICE_API AggregateConformancePackComplianceFilters(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONFIGSERVICE_API AggregateConformancePackComplianceFilters& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CONFIGSERVICE_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the conformance pack.</p>
   */
  inline const Aws::String& GetConformancePackName() const { return m_conformancePackName; }
  inline bool ConformancePackNameHasBeenSet() const { return m_conformancePackNameHasBeenSet; }
  template <typename ConformancePackNameT = Aws::String>
  void SetConformancePackName(ConformancePackNameT&& value) {
    m_conformancePackNameHasBeenSet = true;
    m_conformancePackName = std::forward<ConformancePackNameT>(value);
  }
  template <typename ConformancePackNameT = Aws::String>
  AggregateConformancePackComplianceFilters& WithConformancePackName(ConformancePackNameT&& value) {
    SetConformancePackName(std::forward<ConformancePackNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The compliance status of the conformance pack.</p>
   */
  inline ConformancePackComplianceType GetComplianceType() const { return m_complianceType; }
  inline bool ComplianceTypeHasBeenSet() const { return m_complianceTypeHasBeenSet; }
  inline void SetComplianceType(ConformancePackComplianceType value) {
    m_complianceTypeHasBeenSet = true;
    m_complianceType = value;
  }
  inline AggregateConformancePackComplianceFilters& WithComplianceType(ConformancePackComplianceType value) {
    SetComplianceType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The 12-digit Amazon Web Services account ID of the source account.</p>
   */
  inline const Aws::String& GetAccountId() const { return m_accountId; }
  inline bool AccountIdHasBeenSet() const { return m_accountIdHasBeenSet; }
  template <typename AccountIdT = Aws::String>
  void SetAccountId(AccountIdT&& value) {
    m_accountIdHasBeenSet = true;
    m_accountId = std::forward<AccountIdT>(value);
  }
  template <typename AccountIdT = Aws::String>
  AggregateConformancePackComplianceFilters& WithAccountId(AccountIdT&& value) {
    SetAccountId(std::forward<AccountIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The source Amazon Web Services Region from where the data is aggregated.</p>
   */
  inline const Aws::String& GetAwsRegion() const { return m_awsRegion; }
  inline bool AwsRegionHasBeenSet() const { return m_awsRegionHasBeenSet; }
  template <typename AwsRegionT = Aws::String>
  void SetAwsRegion(AwsRegionT&& value) {
    m_awsRegionHasBeenSet = true;
    m_awsRegion = std::forward<AwsRegionT>(value);
  }
  template <typename AwsRegionT = Aws::String>
  AggregateConformancePackComplianceFilters& WithAwsRegion(AwsRegionT&& value) {
    SetAwsRegion(std::forward<AwsRegionT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_conformancePackName;
  bool m_conformancePackNameHasBeenSet = false;

  ConformancePackComplianceType m_complianceType{ConformancePackComplianceType::NOT_SET};
  bool m_complianceTypeHasBeenSet = false;

  Aws::String m_accountId;
  bool m_accountIdHasBeenSet = false;

  Aws::String m_awsRegion;
  bool m_awsRegionHasBeenSet = false;
};

}  // namespace Model
}  // namespace ConfigService
}  // namespace Aws
