﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/elasticache/ElastiCache_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace ElastiCache {
namespace Model {

/**
 * <p>Describes a notification topic and its status. Notification topics are used
 * for publishing ElastiCache events to subscribers using Amazon Simple
 * Notification Service (SNS).</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/elasticache-2015-02-02/NotificationConfiguration">AWS
 * API Reference</a></p>
 */
class NotificationConfiguration {
 public:
  AWS_ELASTICACHE_API NotificationConfiguration() = default;
  AWS_ELASTICACHE_API NotificationConfiguration(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_ELASTICACHE_API NotificationConfiguration& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_ELASTICACHE_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_ELASTICACHE_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) that identifies the topic.</p>
   */
  inline const Aws::String& GetTopicArn() const { return m_topicArn; }
  inline bool TopicArnHasBeenSet() const { return m_topicArnHasBeenSet; }
  template <typename TopicArnT = Aws::String>
  void SetTopicArn(TopicArnT&& value) {
    m_topicArnHasBeenSet = true;
    m_topicArn = std::forward<TopicArnT>(value);
  }
  template <typename TopicArnT = Aws::String>
  NotificationConfiguration& WithTopicArn(TopicArnT&& value) {
    SetTopicArn(std::forward<TopicArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The current state of the topic.</p>
   */
  inline const Aws::String& GetTopicStatus() const { return m_topicStatus; }
  inline bool TopicStatusHasBeenSet() const { return m_topicStatusHasBeenSet; }
  template <typename TopicStatusT = Aws::String>
  void SetTopicStatus(TopicStatusT&& value) {
    m_topicStatusHasBeenSet = true;
    m_topicStatus = std::forward<TopicStatusT>(value);
  }
  template <typename TopicStatusT = Aws::String>
  NotificationConfiguration& WithTopicStatus(TopicStatusT&& value) {
    SetTopicStatus(std::forward<TopicStatusT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_topicArn;
  bool m_topicArnHasBeenSet = false;

  Aws::String m_topicStatus;
  bool m_topicStatusHasBeenSet = false;
};

}  // namespace Model
}  // namespace ElastiCache
}  // namespace Aws
