﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/elasticloadbalancingv2/ElasticLoadBalancingv2_EXPORTS.h>
#include <aws/elasticloadbalancingv2/model/ResponseMetadata.h>
#include <aws/elasticloadbalancingv2/model/TrustStore.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace ElasticLoadBalancingv2 {
namespace Model {
class DescribeTrustStoresResult {
 public:
  AWS_ELASTICLOADBALANCINGV2_API DescribeTrustStoresResult() = default;
  AWS_ELASTICLOADBALANCINGV2_API DescribeTrustStoresResult(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_ELASTICLOADBALANCINGV2_API DescribeTrustStoresResult& operator=(
      const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>Information about the trust stores.</p>
   */
  inline const Aws::Vector<TrustStore>& GetTrustStores() const { return m_trustStores; }
  template <typename TrustStoresT = Aws::Vector<TrustStore>>
  void SetTrustStores(TrustStoresT&& value) {
    m_trustStoresHasBeenSet = true;
    m_trustStores = std::forward<TrustStoresT>(value);
  }
  template <typename TrustStoresT = Aws::Vector<TrustStore>>
  DescribeTrustStoresResult& WithTrustStores(TrustStoresT&& value) {
    SetTrustStores(std::forward<TrustStoresT>(value));
    return *this;
  }
  template <typename TrustStoresT = TrustStore>
  DescribeTrustStoresResult& AddTrustStores(TrustStoresT&& value) {
    m_trustStoresHasBeenSet = true;
    m_trustStores.emplace_back(std::forward<TrustStoresT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If there are additional results, this is the marker for the next set of
   * results. Otherwise, this is null.</p>
   */
  inline const Aws::String& GetNextMarker() const { return m_nextMarker; }
  template <typename NextMarkerT = Aws::String>
  void SetNextMarker(NextMarkerT&& value) {
    m_nextMarkerHasBeenSet = true;
    m_nextMarker = std::forward<NextMarkerT>(value);
  }
  template <typename NextMarkerT = Aws::String>
  DescribeTrustStoresResult& WithNextMarker(NextMarkerT&& value) {
    SetNextMarker(std::forward<NextMarkerT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DescribeTrustStoresResult& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<TrustStore> m_trustStores;
  bool m_trustStoresHasBeenSet = false;

  Aws::String m_nextMarker;
  bool m_nextMarkerHasBeenSet = false;

  ResponseMetadata m_responseMetadata;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace ElasticLoadBalancingv2
}  // namespace Aws
