﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot/IoTRequest.h>
#include <aws/iot/IoT_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace IoT {
namespace Model {

/**
 */
class AttachSecurityProfileRequest : public IoTRequest {
 public:
  AWS_IOT_API AttachSecurityProfileRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "AttachSecurityProfile"; }

  AWS_IOT_API Aws::String SerializePayload() const override;

  AWS_IOT_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The security profile that is attached.</p>
   */
  inline const Aws::String& GetSecurityProfileName() const { return m_securityProfileName; }
  inline bool SecurityProfileNameHasBeenSet() const { return m_securityProfileNameHasBeenSet; }
  template <typename SecurityProfileNameT = Aws::String>
  void SetSecurityProfileName(SecurityProfileNameT&& value) {
    m_securityProfileNameHasBeenSet = true;
    m_securityProfileName = std::forward<SecurityProfileNameT>(value);
  }
  template <typename SecurityProfileNameT = Aws::String>
  AttachSecurityProfileRequest& WithSecurityProfileName(SecurityProfileNameT&& value) {
    SetSecurityProfileName(std::forward<SecurityProfileNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ARN of the target (thing group) to which the security profile is
   * attached.</p>
   */
  inline const Aws::String& GetSecurityProfileTargetArn() const { return m_securityProfileTargetArn; }
  inline bool SecurityProfileTargetArnHasBeenSet() const { return m_securityProfileTargetArnHasBeenSet; }
  template <typename SecurityProfileTargetArnT = Aws::String>
  void SetSecurityProfileTargetArn(SecurityProfileTargetArnT&& value) {
    m_securityProfileTargetArnHasBeenSet = true;
    m_securityProfileTargetArn = std::forward<SecurityProfileTargetArnT>(value);
  }
  template <typename SecurityProfileTargetArnT = Aws::String>
  AttachSecurityProfileRequest& WithSecurityProfileTargetArn(SecurityProfileTargetArnT&& value) {
    SetSecurityProfileTargetArn(std::forward<SecurityProfileTargetArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_securityProfileName;
  bool m_securityProfileNameHasBeenSet = false;

  Aws::String m_securityProfileTargetArn;
  bool m_securityProfileTargetArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoT
}  // namespace Aws
