﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/iot/IoTRequest.h>
#include <aws/iot/IoT_EXPORTS.h>
#include <aws/iot/model/ResourceIdentifier.h>

#include <utility>

namespace Aws {
namespace IoT {
namespace Model {

/**
 */
class ListAuditSuppressionsRequest : public IoTRequest {
 public:
  AWS_IOT_API ListAuditSuppressionsRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "ListAuditSuppressions"; }

  AWS_IOT_API Aws::String SerializePayload() const override;

  ///@{

  inline const Aws::String& GetCheckName() const { return m_checkName; }
  inline bool CheckNameHasBeenSet() const { return m_checkNameHasBeenSet; }
  template <typename CheckNameT = Aws::String>
  void SetCheckName(CheckNameT&& value) {
    m_checkNameHasBeenSet = true;
    m_checkName = std::forward<CheckNameT>(value);
  }
  template <typename CheckNameT = Aws::String>
  ListAuditSuppressionsRequest& WithCheckName(CheckNameT&& value) {
    SetCheckName(std::forward<CheckNameT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResourceIdentifier& GetResourceIdentifier() const { return m_resourceIdentifier; }
  inline bool ResourceIdentifierHasBeenSet() const { return m_resourceIdentifierHasBeenSet; }
  template <typename ResourceIdentifierT = ResourceIdentifier>
  void SetResourceIdentifier(ResourceIdentifierT&& value) {
    m_resourceIdentifierHasBeenSet = true;
    m_resourceIdentifier = std::forward<ResourceIdentifierT>(value);
  }
  template <typename ResourceIdentifierT = ResourceIdentifier>
  ListAuditSuppressionsRequest& WithResourceIdentifier(ResourceIdentifierT&& value) {
    SetResourceIdentifier(std::forward<ResourceIdentifierT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> Determines whether suppressions are listed in ascending order by expiration
   * date or not. If parameter isn't provided, <code>ascendingOrder=true</code>. </p>
   */
  inline bool GetAscendingOrder() const { return m_ascendingOrder; }
  inline bool AscendingOrderHasBeenSet() const { return m_ascendingOrderHasBeenSet; }
  inline void SetAscendingOrder(bool value) {
    m_ascendingOrderHasBeenSet = true;
    m_ascendingOrder = value;
  }
  inline ListAuditSuppressionsRequest& WithAscendingOrder(bool value) {
    SetAscendingOrder(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The token for the next set of results. </p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListAuditSuppressionsRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The maximum number of results to return at one time. The default is 25. </p>
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline ListAuditSuppressionsRequest& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_checkName;
  bool m_checkNameHasBeenSet = false;

  ResourceIdentifier m_resourceIdentifier;
  bool m_resourceIdentifierHasBeenSet = false;

  bool m_ascendingOrder{false};
  bool m_ascendingOrderHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  int m_maxResults{0};
  bool m_maxResultsHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoT
}  // namespace Aws
