﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/iotsitewise/IoTSiteWise_EXPORTS.h>
#include <aws/iotsitewise/model/PortalSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace IoTSiteWise {
namespace Model {
class ListPortalsResult {
 public:
  AWS_IOTSITEWISE_API ListPortalsResult() = default;
  AWS_IOTSITEWISE_API ListPortalsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IOTSITEWISE_API ListPortalsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list that summarizes each portal.</p>
   */
  inline const Aws::Vector<PortalSummary>& GetPortalSummaries() const { return m_portalSummaries; }
  template <typename PortalSummariesT = Aws::Vector<PortalSummary>>
  void SetPortalSummaries(PortalSummariesT&& value) {
    m_portalSummariesHasBeenSet = true;
    m_portalSummaries = std::forward<PortalSummariesT>(value);
  }
  template <typename PortalSummariesT = Aws::Vector<PortalSummary>>
  ListPortalsResult& WithPortalSummaries(PortalSummariesT&& value) {
    SetPortalSummaries(std::forward<PortalSummariesT>(value));
    return *this;
  }
  template <typename PortalSummariesT = PortalSummary>
  ListPortalsResult& AddPortalSummaries(PortalSummariesT&& value) {
    m_portalSummariesHasBeenSet = true;
    m_portalSummaries.emplace_back(std::forward<PortalSummariesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token for the next set of results, or null if there are no additional
   * results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListPortalsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListPortalsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<PortalSummary> m_portalSummaries;
  bool m_portalSummariesHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoTSiteWise
}  // namespace Aws
