﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/kafka/Kafka_EXPORTS.h>
#include <aws/kafka/model/ClusterState.h>
#include <aws/kafka/model/ClusterType.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Kafka {
namespace Model {
class CreateClusterV2Result {
 public:
  AWS_KAFKA_API CreateClusterV2Result() = default;
  AWS_KAFKA_API CreateClusterV2Result(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_KAFKA_API CreateClusterV2Result& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   *
          <p>The Amazon Resource Name (ARN) of the cluster.</p>

   */
  inline const Aws::String& GetClusterArn() const { return m_clusterArn; }
  template <typename ClusterArnT = Aws::String>
  void SetClusterArn(ClusterArnT&& value) {
    m_clusterArnHasBeenSet = true;
    m_clusterArn = std::forward<ClusterArnT>(value);
  }
  template <typename ClusterArnT = Aws::String>
  CreateClusterV2Result& WithClusterArn(ClusterArnT&& value) {
    SetClusterArn(std::forward<ClusterArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   *
          <p>The name of the MSK cluster.</p>

   */
  inline const Aws::String& GetClusterName() const { return m_clusterName; }
  template <typename ClusterNameT = Aws::String>
  void SetClusterName(ClusterNameT&& value) {
    m_clusterNameHasBeenSet = true;
    m_clusterName = std::forward<ClusterNameT>(value);
  }
  template <typename ClusterNameT = Aws::String>
  CreateClusterV2Result& WithClusterName(ClusterNameT&& value) {
    SetClusterName(std::forward<ClusterNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   *
          <p>The state of the cluster. The possible states are ACTIVE,
   * CREATING, DELETING, FAILED, HEALING, MAINTENANCE, REBOOTING_BROKER, and
   * UPDATING.</p>

   */
  inline ClusterState GetState() const { return m_state; }
  inline void SetState(ClusterState value) {
    m_stateHasBeenSet = true;
    m_state = value;
  }
  inline CreateClusterV2Result& WithState(ClusterState value) {
    SetState(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   *
          <p>The type of the cluster. The possible states are PROVISIONED or
   * SERVERLESS.</p>

   */
  inline ClusterType GetClusterType() const { return m_clusterType; }
  inline void SetClusterType(ClusterType value) {
    m_clusterTypeHasBeenSet = true;
    m_clusterType = value;
  }
  inline CreateClusterV2Result& WithClusterType(ClusterType value) {
    SetClusterType(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateClusterV2Result& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_clusterArn;
  bool m_clusterArnHasBeenSet = false;

  Aws::String m_clusterName;
  bool m_clusterNameHasBeenSet = false;

  ClusterState m_state{ClusterState::NOT_SET};
  bool m_stateHasBeenSet = false;

  ClusterType m_clusterType{ClusterType::NOT_SET};
  bool m_clusterTypeHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Kafka
}  // namespace Aws
