﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/kafkaconnect/KafkaConnect_EXPORTS.h>
#include <aws/kafkaconnect/model/CustomPluginRevisionSummary.h>
#include <aws/kafkaconnect/model/CustomPluginState.h>
#include <aws/kafkaconnect/model/StateDescription.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace KafkaConnect {
namespace Model {
class DescribeCustomPluginResult {
 public:
  AWS_KAFKACONNECT_API DescribeCustomPluginResult() = default;
  AWS_KAFKACONNECT_API DescribeCustomPluginResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_KAFKACONNECT_API DescribeCustomPluginResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The time that the custom plugin was created.</p>
   */
  inline const Aws::Utils::DateTime& GetCreationTime() const { return m_creationTime; }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  void SetCreationTime(CreationTimeT&& value) {
    m_creationTimeHasBeenSet = true;
    m_creationTime = std::forward<CreationTimeT>(value);
  }
  template <typename CreationTimeT = Aws::Utils::DateTime>
  DescribeCustomPluginResult& WithCreationTime(CreationTimeT&& value) {
    SetCreationTime(std::forward<CreationTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the custom plugin.</p>
   */
  inline const Aws::String& GetCustomPluginArn() const { return m_customPluginArn; }
  template <typename CustomPluginArnT = Aws::String>
  void SetCustomPluginArn(CustomPluginArnT&& value) {
    m_customPluginArnHasBeenSet = true;
    m_customPluginArn = std::forward<CustomPluginArnT>(value);
  }
  template <typename CustomPluginArnT = Aws::String>
  DescribeCustomPluginResult& WithCustomPluginArn(CustomPluginArnT&& value) {
    SetCustomPluginArn(std::forward<CustomPluginArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The state of the custom plugin.</p>
   */
  inline CustomPluginState GetCustomPluginState() const { return m_customPluginState; }
  inline void SetCustomPluginState(CustomPluginState value) {
    m_customPluginStateHasBeenSet = true;
    m_customPluginState = value;
  }
  inline DescribeCustomPluginResult& WithCustomPluginState(CustomPluginState value) {
    SetCustomPluginState(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The description of the custom plugin.</p>
   */
  inline const Aws::String& GetDescription() const { return m_description; }
  template <typename DescriptionT = Aws::String>
  void SetDescription(DescriptionT&& value) {
    m_descriptionHasBeenSet = true;
    m_description = std::forward<DescriptionT>(value);
  }
  template <typename DescriptionT = Aws::String>
  DescribeCustomPluginResult& WithDescription(DescriptionT&& value) {
    SetDescription(std::forward<DescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The latest successfully created revision of the custom plugin. If there are
   * no successfully created revisions, this field will be absent.</p>
   */
  inline const CustomPluginRevisionSummary& GetLatestRevision() const { return m_latestRevision; }
  template <typename LatestRevisionT = CustomPluginRevisionSummary>
  void SetLatestRevision(LatestRevisionT&& value) {
    m_latestRevisionHasBeenSet = true;
    m_latestRevision = std::forward<LatestRevisionT>(value);
  }
  template <typename LatestRevisionT = CustomPluginRevisionSummary>
  DescribeCustomPluginResult& WithLatestRevision(LatestRevisionT&& value) {
    SetLatestRevision(std::forward<LatestRevisionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the custom plugin.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  DescribeCustomPluginResult& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Details about the state of a custom plugin.</p>
   */
  inline const StateDescription& GetStateDescription() const { return m_stateDescription; }
  template <typename StateDescriptionT = StateDescription>
  void SetStateDescription(StateDescriptionT&& value) {
    m_stateDescriptionHasBeenSet = true;
    m_stateDescription = std::forward<StateDescriptionT>(value);
  }
  template <typename StateDescriptionT = StateDescription>
  DescribeCustomPluginResult& WithStateDescription(StateDescriptionT&& value) {
    SetStateDescription(std::forward<StateDescriptionT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  DescribeCustomPluginResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Utils::DateTime m_creationTime{};
  bool m_creationTimeHasBeenSet = false;

  Aws::String m_customPluginArn;
  bool m_customPluginArnHasBeenSet = false;

  CustomPluginState m_customPluginState{CustomPluginState::NOT_SET};
  bool m_customPluginStateHasBeenSet = false;

  Aws::String m_description;
  bool m_descriptionHasBeenSet = false;

  CustomPluginRevisionSummary m_latestRevision;
  bool m_latestRevisionHasBeenSet = false;

  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  StateDescription m_stateDescription;
  bool m_stateDescriptionHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace KafkaConnect
}  // namespace Aws
