﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/m2/MainframeModernizationRequest.h>
#include <aws/m2/MainframeModernization_EXPORTS.h>

#include <utility>

namespace Aws {
namespace MainframeModernization {
namespace Model {

/**
 */
class GetDataSetDetailsRequest : public MainframeModernizationRequest {
 public:
  AWS_MAINFRAMEMODERNIZATION_API GetDataSetDetailsRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetDataSetDetails"; }

  AWS_MAINFRAMEMODERNIZATION_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The unique identifier of the application that this data set is associated
   * with.</p>
   */
  inline const Aws::String& GetApplicationId() const { return m_applicationId; }
  inline bool ApplicationIdHasBeenSet() const { return m_applicationIdHasBeenSet; }
  template <typename ApplicationIdT = Aws::String>
  void SetApplicationId(ApplicationIdT&& value) {
    m_applicationIdHasBeenSet = true;
    m_applicationId = std::forward<ApplicationIdT>(value);
  }
  template <typename ApplicationIdT = Aws::String>
  GetDataSetDetailsRequest& WithApplicationId(ApplicationIdT&& value) {
    SetApplicationId(std::forward<ApplicationIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the data set.</p>
   */
  inline const Aws::String& GetDataSetName() const { return m_dataSetName; }
  inline bool DataSetNameHasBeenSet() const { return m_dataSetNameHasBeenSet; }
  template <typename DataSetNameT = Aws::String>
  void SetDataSetName(DataSetNameT&& value) {
    m_dataSetNameHasBeenSet = true;
    m_dataSetName = std::forward<DataSetNameT>(value);
  }
  template <typename DataSetNameT = Aws::String>
  GetDataSetDetailsRequest& WithDataSetName(DataSetNameT&& value) {
    SetDataSetName(std::forward<DataSetNameT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_applicationId;
  bool m_applicationIdHasBeenSet = false;

  Aws::String m_dataSetName;
  bool m_dataSetNameHasBeenSet = false;
};

}  // namespace Model
}  // namespace MainframeModernization
}  // namespace Aws
