﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/memorydb/MemoryDB_EXPORTS.h>
#include <aws/memorydb/model/Authentication.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace MemoryDB {
namespace Model {

/**
 * <p>You create users and assign them specific permissions by using an access
 * string. You assign the users to Access Control Lists aligned with a specific
 * role (administrators, human resources) that are then deployed to one or more
 * MemoryDB clusters.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/memorydb-2021-01-01/User">AWS API
 * Reference</a></p>
 */
class User {
 public:
  AWS_MEMORYDB_API User() = default;
  AWS_MEMORYDB_API User(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEMORYDB_API User& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEMORYDB_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the user</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  User& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Indicates the user status. Can be "active", "modifying" or "deleting".</p>
   */
  inline const Aws::String& GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  template <typename StatusT = Aws::String>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = Aws::String>
  User& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Access permissions string used for this user.</p>
   */
  inline const Aws::String& GetAccessString() const { return m_accessString; }
  inline bool AccessStringHasBeenSet() const { return m_accessStringHasBeenSet; }
  template <typename AccessStringT = Aws::String>
  void SetAccessString(AccessStringT&& value) {
    m_accessStringHasBeenSet = true;
    m_accessString = std::forward<AccessStringT>(value);
  }
  template <typename AccessStringT = Aws::String>
  User& WithAccessString(AccessStringT&& value) {
    SetAccessString(std::forward<AccessStringT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The names of the Access Control Lists to which the user belongs</p>
   */
  inline const Aws::Vector<Aws::String>& GetACLNames() const { return m_aCLNames; }
  inline bool ACLNamesHasBeenSet() const { return m_aCLNamesHasBeenSet; }
  template <typename ACLNamesT = Aws::Vector<Aws::String>>
  void SetACLNames(ACLNamesT&& value) {
    m_aCLNamesHasBeenSet = true;
    m_aCLNames = std::forward<ACLNamesT>(value);
  }
  template <typename ACLNamesT = Aws::Vector<Aws::String>>
  User& WithACLNames(ACLNamesT&& value) {
    SetACLNames(std::forward<ACLNamesT>(value));
    return *this;
  }
  template <typename ACLNamesT = Aws::String>
  User& AddACLNames(ACLNamesT&& value) {
    m_aCLNamesHasBeenSet = true;
    m_aCLNames.emplace_back(std::forward<ACLNamesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The minimum engine version supported for the user</p>
   */
  inline const Aws::String& GetMinimumEngineVersion() const { return m_minimumEngineVersion; }
  inline bool MinimumEngineVersionHasBeenSet() const { return m_minimumEngineVersionHasBeenSet; }
  template <typename MinimumEngineVersionT = Aws::String>
  void SetMinimumEngineVersion(MinimumEngineVersionT&& value) {
    m_minimumEngineVersionHasBeenSet = true;
    m_minimumEngineVersion = std::forward<MinimumEngineVersionT>(value);
  }
  template <typename MinimumEngineVersionT = Aws::String>
  User& WithMinimumEngineVersion(MinimumEngineVersionT&& value) {
    SetMinimumEngineVersion(std::forward<MinimumEngineVersionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Denotes whether the user requires a password to authenticate.</p>
   */
  inline const Authentication& GetAuthentication() const { return m_authentication; }
  inline bool AuthenticationHasBeenSet() const { return m_authenticationHasBeenSet; }
  template <typename AuthenticationT = Authentication>
  void SetAuthentication(AuthenticationT&& value) {
    m_authenticationHasBeenSet = true;
    m_authentication = std::forward<AuthenticationT>(value);
  }
  template <typename AuthenticationT = Authentication>
  User& WithAuthentication(AuthenticationT&& value) {
    SetAuthentication(std::forward<AuthenticationT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the user. </p>
   */
  inline const Aws::String& GetARN() const { return m_aRN; }
  inline bool ARNHasBeenSet() const { return m_aRNHasBeenSet; }
  template <typename ARNT = Aws::String>
  void SetARN(ARNT&& value) {
    m_aRNHasBeenSet = true;
    m_aRN = std::forward<ARNT>(value);
  }
  template <typename ARNT = Aws::String>
  User& WithARN(ARNT&& value) {
    SetARN(std::forward<ARNT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  Aws::String m_status;
  bool m_statusHasBeenSet = false;

  Aws::String m_accessString;
  bool m_accessStringHasBeenSet = false;

  Aws::Vector<Aws::String> m_aCLNames;
  bool m_aCLNamesHasBeenSet = false;

  Aws::String m_minimumEngineVersion;
  bool m_minimumEngineVersionHasBeenSet = false;

  Authentication m_authentication;
  bool m_authenticationHasBeenSet = false;

  Aws::String m_aRN;
  bool m_aRNHasBeenSet = false;
};

}  // namespace Model
}  // namespace MemoryDB
}  // namespace Aws
