﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/organizations/Organizations_EXPORTS.h>

namespace Aws {
namespace Organizations {
namespace Model {
enum class ConstraintViolationExceptionReason {
  NOT_SET,
  ACCOUNT_NUMBER_LIMIT_EXCEEDED,
  HANDSHAKE_RATE_LIMIT_EXCEEDED,
  OU_NUMBER_LIMIT_EXCEEDED,
  OU_DEPTH_LIMIT_EXCEEDED,
  POLICY_NUMBER_LIMIT_EXCEEDED,
  POLICY_CONTENT_LIMIT_EXCEEDED,
  MAX_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED,
  MIN_POLICY_TYPE_ATTACHMENT_LIMIT_EXCEEDED,
  ACCOUNT_CANNOT_LEAVE_ORGANIZATION,
  ACCOUNT_CANNOT_LEAVE_WITHOUT_EULA,
  ACCOUNT_CANNOT_LEAVE_WITHOUT_PHONE_VERIFICATION,
  MASTER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED,
  MEMBER_ACCOUNT_PAYMENT_INSTRUMENT_REQUIRED,
  ACCOUNT_CREATION_RATE_LIMIT_EXCEEDED,
  MASTER_ACCOUNT_ADDRESS_DOES_NOT_MATCH_MARKETPLACE,
  MASTER_ACCOUNT_MISSING_CONTACT_INFO,
  MASTER_ACCOUNT_NOT_GOVCLOUD_ENABLED,
  ORGANIZATION_NOT_IN_ALL_FEATURES_MODE,
  CREATE_ORGANIZATION_IN_BILLING_MODE_UNSUPPORTED_REGION,
  EMAIL_VERIFICATION_CODE_EXPIRED,
  WAIT_PERIOD_ACTIVE,
  MAX_TAG_LIMIT_EXCEEDED,
  TAG_POLICY_VIOLATION,
  MAX_DELEGATED_ADMINISTRATORS_FOR_SERVICE_LIMIT_EXCEEDED,
  CANNOT_REGISTER_MASTER_AS_DELEGATED_ADMINISTRATOR,
  CANNOT_REMOVE_DELEGATED_ADMINISTRATOR_FROM_ORG,
  DELEGATED_ADMINISTRATOR_EXISTS_FOR_THIS_SERVICE,
  POLICY_TYPE_ENABLED_FOR_THIS_SERVICE,
  MASTER_ACCOUNT_MISSING_BUSINESS_LICENSE,
  CANNOT_CLOSE_MANAGEMENT_ACCOUNT,
  CLOSE_ACCOUNT_QUOTA_EXCEEDED,
  CLOSE_ACCOUNT_REQUESTS_LIMIT_EXCEEDED,
  SERVICE_ACCESS_NOT_ENABLED,
  INVALID_PAYMENT_INSTRUMENT,
  ACCOUNT_CREATION_NOT_COMPLETE,
  CANNOT_REGISTER_SUSPENDED_ACCOUNT_AS_DELEGATED_ADMINISTRATOR,
  ALL_FEATURES_MIGRATION_ORGANIZATION_SIZE_LIMIT_EXCEEDED,
  RESPONSIBILITY_TRANSFER_MAX_LEVEL_VIOLATION,
  RESPONSIBILITY_TRANSFER_MAX_INBOUND_QUOTA_VIOLATION,
  RESPONSIBILITY_TRANSFER_MAX_OUTBOUND_QUOTA_VIOLATION,
  RESPONSIBILITY_TRANSFER_MAX_TRANSFERS_QUOTA_VIOLATION,
  ACTIVE_RESPONSIBILITY_TRANSFER_PROCESS,
  TRANSFER_RESPONSIBILITY_TARGET_DELETION_IN_PROGRESS,
  TRANSFER_RESPONSIBILITY_SOURCE_DELETION_IN_PROGRESS,
  UNSUPPORTED_PRICING
};

namespace ConstraintViolationExceptionReasonMapper {
AWS_ORGANIZATIONS_API ConstraintViolationExceptionReason GetConstraintViolationExceptionReasonForName(const Aws::String& name);

AWS_ORGANIZATIONS_API Aws::String GetNameForConstraintViolationExceptionReason(ConstraintViolationExceptionReason value);
}  // namespace ConstraintViolationExceptionReasonMapper
}  // namespace Model
}  // namespace Organizations
}  // namespace Aws
