﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/outposts/Outposts_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Outposts {
namespace Model {
class StartConnectionResult {
 public:
  AWS_OUTPOSTS_API StartConnectionResult() = default;
  AWS_OUTPOSTS_API StartConnectionResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_OUTPOSTS_API StartConnectionResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> The ID of the connection. </p>
   */
  inline const Aws::String& GetConnectionId() const { return m_connectionId; }
  template <typename ConnectionIdT = Aws::String>
  void SetConnectionId(ConnectionIdT&& value) {
    m_connectionIdHasBeenSet = true;
    m_connectionId = std::forward<ConnectionIdT>(value);
  }
  template <typename ConnectionIdT = Aws::String>
  StartConnectionResult& WithConnectionId(ConnectionIdT&& value) {
    SetConnectionId(std::forward<ConnectionIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The underlay IP address. </p>
   */
  inline const Aws::String& GetUnderlayIpAddress() const { return m_underlayIpAddress; }
  template <typename UnderlayIpAddressT = Aws::String>
  void SetUnderlayIpAddress(UnderlayIpAddressT&& value) {
    m_underlayIpAddressHasBeenSet = true;
    m_underlayIpAddress = std::forward<UnderlayIpAddressT>(value);
  }
  template <typename UnderlayIpAddressT = Aws::String>
  StartConnectionResult& WithUnderlayIpAddress(UnderlayIpAddressT&& value) {
    SetUnderlayIpAddress(std::forward<UnderlayIpAddressT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  StartConnectionResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_connectionId;
  bool m_connectionIdHasBeenSet = false;

  Aws::String m_underlayIpAddress;
  bool m_underlayIpAddressHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Outposts
}  // namespace Aws
