﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/pca-connector-ad/PcaConnectorAdRequest.h>
#include <aws/pca-connector-ad/PcaConnectorAd_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Http {
class URI;
}  // namespace Http
namespace PcaConnectorAd {
namespace Model {

/**
 */
class ListServicePrincipalNamesRequest : public PcaConnectorAdRequest {
 public:
  AWS_PCACONNECTORAD_API ListServicePrincipalNamesRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "ListServicePrincipalNames"; }

  AWS_PCACONNECTORAD_API Aws::String SerializePayload() const override;

  AWS_PCACONNECTORAD_API void AddQueryStringParameters(Aws::Http::URI& uri) const override;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) that was returned when you called <a
   * href="https://docs.aws.amazon.com/pca-connector-ad/latest/APIReference/API_CreateDirectoryRegistration.html">CreateDirectoryRegistration</a>.</p>
   */
  inline const Aws::String& GetDirectoryRegistrationArn() const { return m_directoryRegistrationArn; }
  inline bool DirectoryRegistrationArnHasBeenSet() const { return m_directoryRegistrationArnHasBeenSet; }
  template <typename DirectoryRegistrationArnT = Aws::String>
  void SetDirectoryRegistrationArn(DirectoryRegistrationArnT&& value) {
    m_directoryRegistrationArnHasBeenSet = true;
    m_directoryRegistrationArn = std::forward<DirectoryRegistrationArnT>(value);
  }
  template <typename DirectoryRegistrationArnT = Aws::String>
  ListServicePrincipalNamesRequest& WithDirectoryRegistrationArn(DirectoryRegistrationArnT&& value) {
    SetDirectoryRegistrationArn(std::forward<DirectoryRegistrationArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Use this parameter when paginating results to specify the maximum number of
   * items to return in the response on each page. If additional items exist beyond
   * the number you specify, the <code>NextToken</code> element is sent in the
   * response. Use this <code>NextToken</code> value in a subsequent request to
   * retrieve additional items.</p>
   */
  inline int GetMaxResults() const { return m_maxResults; }
  inline bool MaxResultsHasBeenSet() const { return m_maxResultsHasBeenSet; }
  inline void SetMaxResults(int value) {
    m_maxResultsHasBeenSet = true;
    m_maxResults = value;
  }
  inline ListServicePrincipalNamesRequest& WithMaxResults(int value) {
    SetMaxResults(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Use this parameter when paginating results in a subsequent request after you
   * receive a response with truncated results. Set it to the value of the
   * <code>NextToken</code> parameter from the response you just received.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  inline bool NextTokenHasBeenSet() const { return m_nextTokenHasBeenSet; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListServicePrincipalNamesRequest& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_directoryRegistrationArn;
  bool m_directoryRegistrationArnHasBeenSet = false;

  int m_maxResults{0};
  bool m_maxResultsHasBeenSet = false;

  Aws::String m_nextToken;
  bool m_nextTokenHasBeenSet = false;
};

}  // namespace Model
}  // namespace PcaConnectorAd
}  // namespace Aws
