﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/personalize/Personalize_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Personalize {
namespace Model {
class CreateDatasetExportJobResult {
 public:
  AWS_PERSONALIZE_API CreateDatasetExportJobResult() = default;
  AWS_PERSONALIZE_API CreateDatasetExportJobResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_PERSONALIZE_API CreateDatasetExportJobResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the dataset export job.</p>
   */
  inline const Aws::String& GetDatasetExportJobArn() const { return m_datasetExportJobArn; }
  template <typename DatasetExportJobArnT = Aws::String>
  void SetDatasetExportJobArn(DatasetExportJobArnT&& value) {
    m_datasetExportJobArnHasBeenSet = true;
    m_datasetExportJobArn = std::forward<DatasetExportJobArnT>(value);
  }
  template <typename DatasetExportJobArnT = Aws::String>
  CreateDatasetExportJobResult& WithDatasetExportJobArn(DatasetExportJobArnT&& value) {
    SetDatasetExportJobArn(std::forward<DatasetExportJobArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateDatasetExportJobResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_datasetExportJobArn;
  bool m_datasetExportJobArnHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Personalize
}  // namespace Aws
