﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSStreamFwd.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/redshift/Redshift_EXPORTS.h>
#include <aws/redshift/model/ClusterParameterStatus.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Xml {
class XmlNode;
}  // namespace Xml
}  // namespace Utils
namespace Redshift {
namespace Model {

/**
 * <p>Describes the status of a parameter group.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/redshift-2012-12-01/ClusterParameterGroupStatus">AWS
 * API Reference</a></p>
 */
class ClusterParameterGroupStatus {
 public:
  AWS_REDSHIFT_API ClusterParameterGroupStatus() = default;
  AWS_REDSHIFT_API ClusterParameterGroupStatus(const Aws::Utils::Xml::XmlNode& xmlNode);
  AWS_REDSHIFT_API ClusterParameterGroupStatus& operator=(const Aws::Utils::Xml::XmlNode& xmlNode);

  AWS_REDSHIFT_API void OutputToStream(Aws::OStream& ostream, const char* location, unsigned index, const char* locationValue) const;
  AWS_REDSHIFT_API void OutputToStream(Aws::OStream& oStream, const char* location) const;

  ///@{
  /**
   * <p>The name of the cluster parameter group.</p>
   */
  inline const Aws::String& GetParameterGroupName() const { return m_parameterGroupName; }
  inline bool ParameterGroupNameHasBeenSet() const { return m_parameterGroupNameHasBeenSet; }
  template <typename ParameterGroupNameT = Aws::String>
  void SetParameterGroupName(ParameterGroupNameT&& value) {
    m_parameterGroupNameHasBeenSet = true;
    m_parameterGroupName = std::forward<ParameterGroupNameT>(value);
  }
  template <typename ParameterGroupNameT = Aws::String>
  ClusterParameterGroupStatus& WithParameterGroupName(ParameterGroupNameT&& value) {
    SetParameterGroupName(std::forward<ParameterGroupNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The status of parameter updates.</p>
   */
  inline const Aws::String& GetParameterApplyStatus() const { return m_parameterApplyStatus; }
  inline bool ParameterApplyStatusHasBeenSet() const { return m_parameterApplyStatusHasBeenSet; }
  template <typename ParameterApplyStatusT = Aws::String>
  void SetParameterApplyStatus(ParameterApplyStatusT&& value) {
    m_parameterApplyStatusHasBeenSet = true;
    m_parameterApplyStatus = std::forward<ParameterApplyStatusT>(value);
  }
  template <typename ParameterApplyStatusT = Aws::String>
  ClusterParameterGroupStatus& WithParameterApplyStatus(ParameterApplyStatusT&& value) {
    SetParameterApplyStatus(std::forward<ParameterApplyStatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The list of parameter statuses.</p> <p> For more information about parameters
   * and parameter groups, go to <a
   * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon
   * Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management
   * Guide</i>.</p>
   */
  inline const Aws::Vector<ClusterParameterStatus>& GetClusterParameterStatusList() const { return m_clusterParameterStatusList; }
  inline bool ClusterParameterStatusListHasBeenSet() const { return m_clusterParameterStatusListHasBeenSet; }
  template <typename ClusterParameterStatusListT = Aws::Vector<ClusterParameterStatus>>
  void SetClusterParameterStatusList(ClusterParameterStatusListT&& value) {
    m_clusterParameterStatusListHasBeenSet = true;
    m_clusterParameterStatusList = std::forward<ClusterParameterStatusListT>(value);
  }
  template <typename ClusterParameterStatusListT = Aws::Vector<ClusterParameterStatus>>
  ClusterParameterGroupStatus& WithClusterParameterStatusList(ClusterParameterStatusListT&& value) {
    SetClusterParameterStatusList(std::forward<ClusterParameterStatusListT>(value));
    return *this;
  }
  template <typename ClusterParameterStatusListT = ClusterParameterStatus>
  ClusterParameterGroupStatus& AddClusterParameterStatusList(ClusterParameterStatusListT&& value) {
    m_clusterParameterStatusListHasBeenSet = true;
    m_clusterParameterStatusList.emplace_back(std::forward<ClusterParameterStatusListT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_parameterGroupName;
  bool m_parameterGroupNameHasBeenSet = false;

  Aws::String m_parameterApplyStatus;
  bool m_parameterApplyStatusHasBeenSet = false;

  Aws::Vector<ClusterParameterStatus> m_clusterParameterStatusList;
  bool m_clusterParameterStatusListHasBeenSet = false;
};

}  // namespace Model
}  // namespace Redshift
}  // namespace Aws
