﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/swf/SWF_EXPORTS.h>
#include <aws/swf/model/SignalExternalWorkflowExecutionFailedCause.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace SWF {
namespace Model {

/**
 * <p>Provides the details of the
 * <code>SignalExternalWorkflowExecutionFailed</code> event.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/swf-2012-01-25/SignalExternalWorkflowExecutionFailedEventAttributes">AWS
 * API Reference</a></p>
 */
class SignalExternalWorkflowExecutionFailedEventAttributes {
 public:
  AWS_SWF_API SignalExternalWorkflowExecutionFailedEventAttributes() = default;
  AWS_SWF_API SignalExternalWorkflowExecutionFailedEventAttributes(Aws::Utils::Json::JsonView jsonValue);
  AWS_SWF_API SignalExternalWorkflowExecutionFailedEventAttributes& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_SWF_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The <code>workflowId</code> of the external workflow execution that the
   * signal was being delivered to.</p>
   */
  inline const Aws::String& GetWorkflowId() const { return m_workflowId; }
  inline bool WorkflowIdHasBeenSet() const { return m_workflowIdHasBeenSet; }
  template <typename WorkflowIdT = Aws::String>
  void SetWorkflowId(WorkflowIdT&& value) {
    m_workflowIdHasBeenSet = true;
    m_workflowId = std::forward<WorkflowIdT>(value);
  }
  template <typename WorkflowIdT = Aws::String>
  SignalExternalWorkflowExecutionFailedEventAttributes& WithWorkflowId(WorkflowIdT&& value) {
    SetWorkflowId(std::forward<WorkflowIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The <code>runId</code> of the external workflow execution that the signal was
   * being delivered to.</p>
   */
  inline const Aws::String& GetRunId() const { return m_runId; }
  inline bool RunIdHasBeenSet() const { return m_runIdHasBeenSet; }
  template <typename RunIdT = Aws::String>
  void SetRunId(RunIdT&& value) {
    m_runIdHasBeenSet = true;
    m_runId = std::forward<RunIdT>(value);
  }
  template <typename RunIdT = Aws::String>
  SignalExternalWorkflowExecutionFailedEventAttributes& WithRunId(RunIdT&& value) {
    SetRunId(std::forward<RunIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The cause of the failure. This information is generated by the system and can
   * be useful for diagnostic purposes.</p>  <p>If <code>cause</code> is set to
   * <code>OPERATION_NOT_PERMITTED</code>, the decision failed because it lacked
   * sufficient permissions. For details and example IAM policies, see <a
   * href="https://docs.aws.amazon.com/amazonswf/latest/developerguide/swf-dev-iam.html">Using
   * IAM to Manage Access to Amazon SWF Workflows</a> in the <i>Amazon SWF Developer
   * Guide</i>.</p>
   */
  inline SignalExternalWorkflowExecutionFailedCause GetCause() const { return m_cause; }
  inline bool CauseHasBeenSet() const { return m_causeHasBeenSet; }
  inline void SetCause(SignalExternalWorkflowExecutionFailedCause value) {
    m_causeHasBeenSet = true;
    m_cause = value;
  }
  inline SignalExternalWorkflowExecutionFailedEventAttributes& WithCause(SignalExternalWorkflowExecutionFailedCause value) {
    SetCause(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the <code>SignalExternalWorkflowExecutionInitiated</code> event
   * corresponding to the <code>SignalExternalWorkflowExecution</code> decision to
   * request this signal. This information can be useful for diagnosing problems by
   * tracing back the chain of events leading up to this event.</p>
   */
  inline long long GetInitiatedEventId() const { return m_initiatedEventId; }
  inline bool InitiatedEventIdHasBeenSet() const { return m_initiatedEventIdHasBeenSet; }
  inline void SetInitiatedEventId(long long value) {
    m_initiatedEventIdHasBeenSet = true;
    m_initiatedEventId = value;
  }
  inline SignalExternalWorkflowExecutionFailedEventAttributes& WithInitiatedEventId(long long value) {
    SetInitiatedEventId(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The ID of the <code>DecisionTaskCompleted</code> event corresponding to the
   * decision task that resulted in the <code>SignalExternalWorkflowExecution</code>
   * decision for this signal. This information can be useful for diagnosing problems
   * by tracing back the chain of events leading up to this event.</p>
   */
  inline long long GetDecisionTaskCompletedEventId() const { return m_decisionTaskCompletedEventId; }
  inline bool DecisionTaskCompletedEventIdHasBeenSet() const { return m_decisionTaskCompletedEventIdHasBeenSet; }
  inline void SetDecisionTaskCompletedEventId(long long value) {
    m_decisionTaskCompletedEventIdHasBeenSet = true;
    m_decisionTaskCompletedEventId = value;
  }
  inline SignalExternalWorkflowExecutionFailedEventAttributes& WithDecisionTaskCompletedEventId(long long value) {
    SetDecisionTaskCompletedEventId(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The data attached to the event that the decider can use in subsequent
   * workflow tasks. This data isn't sent to the workflow execution.</p>
   */
  inline const Aws::String& GetControl() const { return m_control; }
  inline bool ControlHasBeenSet() const { return m_controlHasBeenSet; }
  template <typename ControlT = Aws::String>
  void SetControl(ControlT&& value) {
    m_controlHasBeenSet = true;
    m_control = std::forward<ControlT>(value);
  }
  template <typename ControlT = Aws::String>
  SignalExternalWorkflowExecutionFailedEventAttributes& WithControl(ControlT&& value) {
    SetControl(std::forward<ControlT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_workflowId;
  bool m_workflowIdHasBeenSet = false;

  Aws::String m_runId;
  bool m_runIdHasBeenSet = false;

  SignalExternalWorkflowExecutionFailedCause m_cause{SignalExternalWorkflowExecutionFailedCause::NOT_SET};
  bool m_causeHasBeenSet = false;

  long long m_initiatedEventId{0};
  bool m_initiatedEventIdHasBeenSet = false;

  long long m_decisionTaskCompletedEventId{0};
  bool m_decisionTaskCompletedEventIdHasBeenSet = false;

  Aws::String m_control;
  bool m_controlHasBeenSet = false;
};

}  // namespace Model
}  // namespace SWF
}  // namespace Aws
