﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/application-autoscaling/ApplicationAutoScalingRequest.h>
#include <aws/application-autoscaling/ApplicationAutoScaling_EXPORTS.h>
#include <aws/application-autoscaling/model/ScalableDimension.h>
#include <aws/application-autoscaling/model/ServiceNamespace.h>
#include <aws/core/utils/DateTime.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace ApplicationAutoScaling {
namespace Model {

/**
 */
class GetPredictiveScalingForecastRequest : public ApplicationAutoScalingRequest {
 public:
  AWS_APPLICATIONAUTOSCALING_API GetPredictiveScalingForecastRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "GetPredictiveScalingForecast"; }

  AWS_APPLICATIONAUTOSCALING_API Aws::String SerializePayload() const override;

  AWS_APPLICATIONAUTOSCALING_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p> The namespace of the Amazon Web Services service that provides the resource.
   * For a resource provided by your own application or service, use
   * <code>custom-resource</code> instead. </p>
   */
  inline ServiceNamespace GetServiceNamespace() const { return m_serviceNamespace; }
  inline bool ServiceNamespaceHasBeenSet() const { return m_serviceNamespaceHasBeenSet; }
  inline void SetServiceNamespace(ServiceNamespace value) {
    m_serviceNamespaceHasBeenSet = true;
    m_serviceNamespace = value;
  }
  inline GetPredictiveScalingForecastRequest& WithServiceNamespace(ServiceNamespace value) {
    SetServiceNamespace(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The identifier of the resource. </p>
   */
  inline const Aws::String& GetResourceId() const { return m_resourceId; }
  inline bool ResourceIdHasBeenSet() const { return m_resourceIdHasBeenSet; }
  template <typename ResourceIdT = Aws::String>
  void SetResourceId(ResourceIdT&& value) {
    m_resourceIdHasBeenSet = true;
    m_resourceId = std::forward<ResourceIdT>(value);
  }
  template <typename ResourceIdT = Aws::String>
  GetPredictiveScalingForecastRequest& WithResourceId(ResourceIdT&& value) {
    SetResourceId(std::forward<ResourceIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The scalable dimension. </p>
   */
  inline ScalableDimension GetScalableDimension() const { return m_scalableDimension; }
  inline bool ScalableDimensionHasBeenSet() const { return m_scalableDimensionHasBeenSet; }
  inline void SetScalableDimension(ScalableDimension value) {
    m_scalableDimensionHasBeenSet = true;
    m_scalableDimension = value;
  }
  inline GetPredictiveScalingForecastRequest& WithScalableDimension(ScalableDimension value) {
    SetScalableDimension(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the policy.</p>
   */
  inline const Aws::String& GetPolicyName() const { return m_policyName; }
  inline bool PolicyNameHasBeenSet() const { return m_policyNameHasBeenSet; }
  template <typename PolicyNameT = Aws::String>
  void SetPolicyName(PolicyNameT&& value) {
    m_policyNameHasBeenSet = true;
    m_policyName = std::forward<PolicyNameT>(value);
  }
  template <typename PolicyNameT = Aws::String>
  GetPredictiveScalingForecastRequest& WithPolicyName(PolicyNameT&& value) {
    SetPolicyName(std::forward<PolicyNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The inclusive start time of the time range for the forecast data to get. At
   * most, the date and time can be one year before the current date and time </p>
   */
  inline const Aws::Utils::DateTime& GetStartTime() const { return m_startTime; }
  inline bool StartTimeHasBeenSet() const { return m_startTimeHasBeenSet; }
  template <typename StartTimeT = Aws::Utils::DateTime>
  void SetStartTime(StartTimeT&& value) {
    m_startTimeHasBeenSet = true;
    m_startTime = std::forward<StartTimeT>(value);
  }
  template <typename StartTimeT = Aws::Utils::DateTime>
  GetPredictiveScalingForecastRequest& WithStartTime(StartTimeT&& value) {
    SetStartTime(std::forward<StartTimeT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The exclusive end time of the time range for the forecast data to get. The
   * maximum time duration between the start and end time is 30 days. </p>
   */
  inline const Aws::Utils::DateTime& GetEndTime() const { return m_endTime; }
  inline bool EndTimeHasBeenSet() const { return m_endTimeHasBeenSet; }
  template <typename EndTimeT = Aws::Utils::DateTime>
  void SetEndTime(EndTimeT&& value) {
    m_endTimeHasBeenSet = true;
    m_endTime = std::forward<EndTimeT>(value);
  }
  template <typename EndTimeT = Aws::Utils::DateTime>
  GetPredictiveScalingForecastRequest& WithEndTime(EndTimeT&& value) {
    SetEndTime(std::forward<EndTimeT>(value));
    return *this;
  }
  ///@}
 private:
  ServiceNamespace m_serviceNamespace{ServiceNamespace::NOT_SET};

  Aws::String m_resourceId;

  ScalableDimension m_scalableDimension{ScalableDimension::NOT_SET};

  Aws::String m_policyName;

  Aws::Utils::DateTime m_startTime{};

  Aws::Utils::DateTime m_endTime{};
  bool m_serviceNamespaceHasBeenSet = false;
  bool m_resourceIdHasBeenSet = false;
  bool m_scalableDimensionHasBeenSet = false;
  bool m_policyNameHasBeenSet = false;
  bool m_startTimeHasBeenSet = false;
  bool m_endTimeHasBeenSet = false;
};

}  // namespace Model
}  // namespace ApplicationAutoScaling
}  // namespace Aws
