﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/ResponseMetadata.h>
#include <aws/ec2/model/TransitGatewayConnectPeer.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {
class CreateTransitGatewayConnectPeerResponse {
 public:
  AWS_EC2_API CreateTransitGatewayConnectPeerResponse() = default;
  AWS_EC2_API CreateTransitGatewayConnectPeerResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_EC2_API CreateTransitGatewayConnectPeerResponse& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>Information about the Connect peer.</p>
   */
  inline const TransitGatewayConnectPeer& GetTransitGatewayConnectPeer() const { return m_transitGatewayConnectPeer; }
  template <typename TransitGatewayConnectPeerT = TransitGatewayConnectPeer>
  void SetTransitGatewayConnectPeer(TransitGatewayConnectPeerT&& value) {
    m_transitGatewayConnectPeerHasBeenSet = true;
    m_transitGatewayConnectPeer = std::forward<TransitGatewayConnectPeerT>(value);
  }
  template <typename TransitGatewayConnectPeerT = TransitGatewayConnectPeer>
  CreateTransitGatewayConnectPeerResponse& WithTransitGatewayConnectPeer(TransitGatewayConnectPeerT&& value) {
    SetTransitGatewayConnectPeer(std::forward<TransitGatewayConnectPeerT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  CreateTransitGatewayConnectPeerResponse& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  TransitGatewayConnectPeer m_transitGatewayConnectPeer;
  bool m_transitGatewayConnectPeerHasBeenSet = false;

  ResponseMetadata m_responseMetadata;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
