/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.messages;

import io.cucumber.messages.types.Envelope;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class MessageToNdjsonWriter
implements AutoCloseable {
    private final Writer writer;
    private final Serializer serializer;

    public MessageToNdjsonWriter(OutputStream outputStream, Serializer serializer) {
        this(new OutputStreamWriter(Objects.requireNonNull(outputStream), StandardCharsets.UTF_8), Objects.requireNonNull(serializer));
    }

    private MessageToNdjsonWriter(Writer writer, Serializer serializer) {
        this.writer = writer;
        this.serializer = serializer;
    }

    public void write(Envelope message) throws IOException {
        Objects.requireNonNull(message);
        this.serializer.writeValue(this.writer, message);
        this.writer.write("\n");
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @FunctionalInterface
    public static interface Serializer {
        public void writeValue(Writer var1, Envelope var2) throws IOException;
    }
}

