/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute.mindmapmode.clipboard;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import org.freeplane.core.io.xml.XMLLocalParserFactory;
import org.freeplane.core.util.TypeReference;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.attribute.AttributeSelection;
import org.freeplane.features.attribute.IAttributeTableModel;
import org.freeplane.features.attribute.NodeAttribute;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.attribute.clipboard.AttributeClipboardController;
import org.freeplane.features.attribute.clipboard.AttributeTransferable;
import org.freeplane.features.attribute.mindmapmode.MAttributeController;
import org.freeplane.features.clipboard.mindmapmode.MClipboardController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.n3.nanoxml.IXMLParser;
import org.freeplane.n3.nanoxml.IXMLReader;
import org.freeplane.n3.nanoxml.StdXMLReader;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.n3.nanoxml.XMLException;

public class MAttributeClipboardController
extends AttributeClipboardController
implements MClipboardController {
    private final MAttributeController attributeController;

    public MAttributeClipboardController(MAttributeController attributeController) {
        this.attributeController = attributeController;
    }

    @Override
    public boolean canPaste(Transferable t) {
        return t.isDataFlavorSupported(AttributeTransferable.attributesFlavor);
    }

    @Override
    public void paste(ActionEvent event, Transferable t) {
        try {
            AttributeSelection selection = AttributeController.getAttributeSelection();
            NodeModel target = Controller.getCurrentController().getSelection().getSelected();
            if (selection != null && !selection.isEmpty()) {
                List selectedAttributes = selection.getSelectedAttributes();
                if (selectedAttributes.size() == 1 && ((AttributeSelection.SelectedAttribute)selectedAttributes.get(0)).getSelectedPart() != AttributeSelection.SelectedAttribute.SelectedPart.BOTH) {
                    AttributeSelection.SelectedAttribute selected = (AttributeSelection.SelectedAttribute)selectedAttributes.get(0);
                    NodeAttribute nodeAttribute = selected.getSelectedAttribute();
                    NodeModel node = nodeAttribute.node;
                    NodeAttributeTableModel model = (NodeAttributeTableModel)node.getExtension(NodeAttributeTableModel.class);
                    int row = model.getAttributeIndex(nodeAttribute.attribute);
                    int col = selected.getSelectedPart() == AttributeSelection.SelectedAttribute.SelectedPart.NAME ? 0 : 1;
                    Object stringContent = t.getTransferData(DataFlavor.stringFlavor);
                    this.attributeController.performSetValueAt(node, model, stringContent, row, col);
                    return;
                }
                String transferData = (String)t.getTransferData(AttributeTransferable.attributesFlavor);
                IXMLParser parser = XMLLocalParserFactory.createLocalXMLParser();
                StdXMLReader xmlReader = new StdXMLReader((Reader)new StringReader(transferData));
                parser.setReader((IXMLReader)xmlReader);
                ArrayList<Attribute> clipboardAttributes = new ArrayList<Attribute>();
                while (!xmlReader.atEOF()) {
                    XMLElement storage = (XMLElement)parser.parse();
                    String name = storage.getAttribute("name", null);
                    String object = storage.getAttribute("object", null);
                    Object value = TypeReference.create((String)object);
                    clipboardAttributes.add(new Attribute(name, value));
                }
                if (clipboardAttributes.isEmpty()) {
                    return;
                }
                block8: for (int i = 0; i < selectedAttributes.size(); ++i) {
                    AttributeSelection.SelectedAttribute sel = (AttributeSelection.SelectedAttribute)selectedAttributes.get(i);
                    Attribute sourceAttr = (Attribute)clipboardAttributes.get(Math.min(i, clipboardAttributes.size() - 1));
                    NodeAttribute nodeAttr = sel.getSelectedAttribute();
                    NodeModel node = nodeAttr.node;
                    NodeAttributeTableModel model = (NodeAttributeTableModel)node.getExtension(NodeAttributeTableModel.class);
                    int row = model.getAttributeIndex(nodeAttr.attribute);
                    switch (sel.getSelectedPart()) {
                        case NAME: {
                            this.attributeController.performSetValueAt(node, model, sourceAttr.getName(), row, 0);
                            continue block8;
                        }
                        case VALUE: {
                            this.attributeController.performSetValueAt(node, model, sourceAttr.getValue(), row, 1);
                            continue block8;
                        }
                        case BOTH: {
                            this.attributeController.setAttribute(node, row, new Attribute(sourceAttr.getName(), sourceAttr.getValue()));
                            continue block8;
                        }
                    }
                }
                return;
            }
            String transferData = (String)t.getTransferData(AttributeTransferable.attributesFlavor);
            IXMLParser parser = XMLLocalParserFactory.createLocalXMLParser();
            StdXMLReader xmlReader = new StdXMLReader((Reader)new StringReader(transferData));
            parser.setReader((IXMLReader)xmlReader);
            int targetRow = this.targetRow(event);
            while (!xmlReader.atEOF()) {
                XMLElement storage = (XMLElement)parser.parse();
                String name = storage.getAttribute("name", null);
                String object = storage.getAttribute("object", null);
                Object value = TypeReference.create((String)object);
                Attribute attribute = new Attribute(name, value);
                if (targetRow >= 0) {
                    this.attributeController.insertAttribute(target, targetRow++, attribute);
                    continue;
                }
                this.attributeController.addAttribute(target, attribute);
            }
        }
        catch (UnsupportedFlavorException | IOException | XMLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private int targetRow(ActionEvent event) {
        JTable table;
        if (event.getSource() instanceof JTable && (table = (JTable)event.getSource()).getModel() instanceof IAttributeTableModel) {
            int targetRow;
            IAttributeTableModel model = (IAttributeTableModel)table.getModel();
            int selectedRowCount = table.getSelectedRowCount();
            if (selectedRowCount != 0) {
                int[] selectedRows = table.getSelectedRows();
                targetRow = model.targetRow(selectedRows[selectedRows.length - 1]) + 1;
            } else {
                targetRow = 0;
            }
            return targetRow;
        }
        return -1;
    }

    @Override
    public boolean canCut() {
        return this.canCopy();
    }

    @Override
    public void cut() {
        this.copy();
        AttributeSelection attributeSelection = AttributeController.getAttributeSelection();
        attributeSelection.nodeAttributeStream().forEach(this::delete);
    }

    private void delete(NodeAttribute nodeAttribute) {
        NodeModel node = nodeAttribute.node;
        NodeAttributeTableModel model = (NodeAttributeTableModel)node.getExtension(NodeAttributeTableModel.class);
        int attributeIndex = model.getAttributeIndex(nodeAttribute.attribute);
        this.attributeController.performRemoveRow(node, model, attributeIndex);
    }
}

