/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.url.mindmapmode;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.nio.channels.FileLock;
import javax.swing.Timer;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;

public class LockManager {
    static final String LOCK_EXPIRATION_TIME = "lock_expiration_time_in_minutes";
    private File lockedSemaphoreFile = null;
    private String lockingUserOfOldLock = null;
    private final long lockSafetyPeriod = ResourceController.getResourceController().getIntProperty("lock_expiration_time_in_minutes") * 60 * 1000;
    private Timer lockTimer = null;
    private final int lockUpdatePeriod = (int)Math.min(Integer.MAX_VALUE, Math.round((double)this.lockSafetyPeriod * 0.8));

    private File getSemaphoreFile(File mapFile) {
        return new File(mapFile.getParent() + System.getProperty("file.separator") + "$~" + mapFile.getName() + "~");
    }

    public synchronized String popLockingUserOfOldLock() {
        String toReturn = this.lockingUserOfOldLock;
        this.lockingUserOfOldLock = null;
        return toReturn;
    }

    public synchronized void release() {
        if (this.lockedSemaphoreFile != null) {
            this.lockedSemaphoreFile.delete();
            this.lockedSemaphoreFile = null;
        }
        if (this.lockTimer != null) {
            this.lockTimer.stop();
            this.lockTimer = null;
        }
    }

    protected synchronized void updateSemaphoreFile() {
        if (this.lockedSemaphoreFile == null) {
            LogUtils.severe((String)"unexpected: lockedSemaphoreFile is null upon lock update");
            return;
        }
        try {
            FileUtils.setHidden((File)this.lockedSemaphoreFile, (boolean)false, (boolean)true);
            this.writeSemaphoreFile(this.lockedSemaphoreFile);
        }
        catch (Exception e) {
            LogUtils.severe((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized String tryToLock(File file) throws Exception {
        File semaphoreFile = this.getSemaphoreFile(file);
        if (semaphoreFile.equals(this.lockedSemaphoreFile)) {
            return null;
        }
        try (BufferedReader semaphoreReader = new BufferedReader(new FileReader(semaphoreFile));){
            String lockingUser = semaphoreReader.readLine();
            String lockTime = semaphoreReader.readLine();
            if (!this.isLockExpired(lockTime)) {
                String string = lockingUser;
                return string;
            }
            this.lockingUserOfOldLock = lockingUser;
            semaphoreFile.delete();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.writeSemaphoreFile(semaphoreFile);
        this.release();
        this.lockedSemaphoreFile = semaphoreFile;
        if (this.lockTimer != null) return null;
        if (this.lockUpdatePeriod <= 0) return null;
        this.lockTimer = new Timer(this.lockUpdatePeriod, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LockManager.this.updateSemaphoreFile();
            }
        });
        this.lockTimer.start();
        return null;
    }

    private boolean isLockExpired(String lockTimeString) {
        long lockTime = Long.parseLong(lockTimeString);
        long timeDifference = System.currentTimeMillis() - lockTime;
        return lockTimeString == null || this.lockSafetyPeriod > 0L && timeDifference > this.lockSafetyPeriod;
    }

    private void writeSemaphoreFile(File inSemaphoreFile) throws Exception {
        try (FileOutputStream semaphoreOutputStream = new FileOutputStream(inSemaphoreFile);){
            FileLock lock = null;
            try {
                lock = semaphoreOutputStream.getChannel().tryLock();
                if (lock == null) {
                    LogUtils.severe((String)"Locking failed.");
                    throw new Exception();
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                // empty catch block
            }
            semaphoreOutputStream.write(System.getProperty("user.name").getBytes());
            semaphoreOutputStream.write(10);
            semaphoreOutputStream.write(String.valueOf(System.currentTimeMillis()).getBytes());
            FileUtils.setHidden((File)inSemaphoreFile, (boolean)true, (boolean)false);
            if (lock != null) {
                lock.release();
            }
        }
        catch (FileNotFoundException e) {
            if (this.lockTimer != null) {
                this.lockTimer.stop();
            }
            return;
        }
    }
}

