/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.border.Border;
import net.infonode.gui.GraphicsUtil;
import net.infonode.gui.colorprovider.ColorProvider;
import net.infonode.gui.colorprovider.ColorProviderList;
import net.infonode.gui.colorprovider.ColorProviderUtil;
import net.infonode.gui.colorprovider.FixedColorProvider;
import net.infonode.gui.colorprovider.UIManagerColorProvider;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedUtils;
import net.infonode.util.Direction;

public class TabAreaLineBorder
implements Border,
Serializable {
    private static final long serialVersionUID = 1L;
    private ColorProvider color;
    private boolean drawTop;
    private boolean drawLeft;
    private boolean drawRight;
    private boolean flipLeftRight;

    public TabAreaLineBorder() {
        this(null);
    }

    public TabAreaLineBorder(Color color) {
        this(color, true, true, true, false);
    }

    public TabAreaLineBorder(boolean drawTop, boolean drawLeft, boolean drawRight, boolean flipLeftRight) {
        this((Color)null, drawTop, drawLeft, drawRight, flipLeftRight);
    }

    public TabAreaLineBorder(Color color, boolean drawTop, boolean drawLeft, boolean drawRight, boolean flipLeftRight) {
        this(ColorProviderUtil.getColorProvider(color, new ColorProviderList(UIManagerColorProvider.TABBED_PANE_DARK_SHADOW, UIManagerColorProvider.CONTROL_DARK_SHADOW, FixedColorProvider.BLACK)), drawTop, drawLeft, drawRight, flipLeftRight);
    }

    public TabAreaLineBorder(ColorProvider colorProvider, boolean drawTop, boolean drawLeft, boolean drawRight, boolean flipLeftRight) {
        this.color = colorProvider;
        this.drawTop = drawTop;
        this.drawLeft = drawLeft;
        this.drawRight = drawRight;
        this.flipLeftRight = flipLeftRight;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Insets insets = this.getBorderInsets(c);
        g.setColor(this.color.getColor(c));
        if (insets.top == 1) {
            GraphicsUtil.drawOptimizedLine(g, x, y, x + width - 1, y);
        }
        if (insets.bottom == 1) {
            GraphicsUtil.drawOptimizedLine(g, x, y + height - 1, x + width - 1, y + height - 1);
        }
        if (insets.left == 1) {
            GraphicsUtil.drawOptimizedLine(g, x, y, x, y + height - 1);
        }
        if (insets.right == 1) {
            GraphicsUtil.drawOptimizedLine(g, x + width - 1, y, x + width - 1, y + height - 1);
        }
    }

    private boolean drawTop(Direction orientation) {
        return orientation == Direction.UP ? this.drawTop : (orientation == Direction.LEFT ? (this.flipLeftRight ? this.drawLeft : this.drawRight) : (orientation == Direction.RIGHT ? this.drawLeft : false));
    }

    private boolean drawLeft(Direction orientation) {
        return orientation == Direction.UP ? this.drawLeft : (orientation == Direction.LEFT ? this.drawTop : (orientation == Direction.DOWN ? (this.flipLeftRight ? this.drawLeft : this.drawRight) : false));
    }

    private boolean drawRight(Direction orientation) {
        return orientation == Direction.UP ? this.drawRight : (orientation == Direction.LEFT ? false : (orientation == Direction.DOWN ? (this.flipLeftRight ? this.drawRight : this.drawLeft) : this.drawTop));
    }

    private boolean drawBottom(Direction orientation) {
        return orientation == Direction.UP ? false : (orientation == Direction.LEFT ? (this.flipLeftRight ? this.drawRight : this.drawLeft) : (orientation == Direction.RIGHT ? this.drawRight : this.drawTop));
    }

    @Override
    public Insets getBorderInsets(Component c) {
        if (c instanceof JComponent && ((JComponent)c).getComponentCount() == 0) {
            return new Insets(0, 0, 0, 0);
        }
        Direction orientation = TabAreaLineBorder.getTabAreaDirection(c);
        return orientation != null ? new Insets(this.drawTop(orientation) ? 1 : 0, this.drawLeft(orientation) ? 1 : 0, this.drawBottom(orientation) ? 1 : 0, this.drawRight(orientation) ? 1 : 0) : new Insets(0, 0, 0, 0);
    }

    private static Direction getTabAreaDirection(Component c) {
        TabbedPanel tp = TabbedUtils.getParentTabbedPanel(c);
        return tp != null ? tp.getProperties().getTabAreaOrientation() : null;
    }
}

