/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.util;

import java.net.URI;
import java.net.URISyntaxException;

public class URIUtils {
    public static URI createURIFromString(String uriString) throws URISyntaxException {
        if (uriString == null || uriString.trim().isEmpty()) {
            return new URI(null, null, "", null);
        }
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            if (uriString.startsWith("#")) {
                return new URI(uriString);
            }
            if (uriString.contains(" ")) {
                if (uriString.startsWith("file:")) {
                    int queryIndex;
                    String path = uriString.substring(5);
                    String fragment = null;
                    String query = null;
                    int fragmentIndex = path.indexOf(35);
                    if (fragmentIndex >= 0) {
                        fragment = path.substring(fragmentIndex + 1);
                        path = path.substring(0, fragmentIndex);
                    }
                    if ((queryIndex = path.indexOf(63)) >= 0) {
                        query = path.substring(queryIndex + 1);
                        path = path.substring(0, queryIndex);
                    }
                    return new URI("file", null, path, query, fragment);
                }
                if (!uriString.contains("://")) {
                    int queryIndex;
                    String fragment = null;
                    String query = null;
                    int fragmentIndex = uriString.indexOf(35);
                    if (fragmentIndex >= 0) {
                        fragment = uriString.substring(fragmentIndex + 1);
                        uriString = uriString.substring(0, fragmentIndex);
                    }
                    if ((queryIndex = uriString.indexOf(63)) >= 0) {
                        query = uriString.substring(queryIndex + 1);
                        uriString = uriString.substring(0, queryIndex);
                    }
                    return new URI(null, null, uriString, query, fragment);
                }
            }
            throw e;
        }
    }
}

