/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.attribute;

import java.io.IOException;
import java.util.Vector;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.BackwardCompatibleQuantityWriter;
import org.freeplane.core.io.IAttributeHandler;
import org.freeplane.core.io.IAttributeWriter;
import org.freeplane.core.io.IElementDOMHandler;
import org.freeplane.core.io.IElementHandler;
import org.freeplane.core.io.IExtensionElementWriter;
import org.freeplane.core.io.ITreeWriter;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TypeReference;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.attribute.AttributeRegistry;
import org.freeplane.features.attribute.AttributeTableLayoutModel;
import org.freeplane.features.attribute.FontSizeExtension;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapReader;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.text.TextController;
import org.freeplane.n3.nanoxml.XMLElement;

class AttributeBuilder
implements IElementDOMHandler {
    public static final String XML_NODE_ATTRIBUTE = "attribute";
    public static final String XML_NODE_ATTRIBUTE_LAYOUT = "attribute_layout";
    public static final String XML_NODE_ATTRIBUTE_REGISTRY = "attribute_registry";
    public static final String XML_NODE_REGISTERED_ATTRIBUTE_NAME = "attribute_name";
    public static final String XML_NODE_REGISTERED_ATTRIBUTE_VALUE = "attribute_value";
    private final AttributeController attributeController;
    private final MapReader mapReader;
    private static final Quantity<LengthUnit> DEFAULT_COLUMN_WIDTH = new Quantity(60.0, (Enum)LengthUnit.pt);

    public AttributeBuilder(AttributeController attributeController, MapReader mapReader) {
        this.attributeController = attributeController;
        this.mapReader = mapReader;
    }

    @Override
    public Object createElement(Object parent, String tag, XMLElement attributes) {
        if (tag.equals(XML_NODE_ATTRIBUTE) || tag.equals(XML_NODE_REGISTERED_ATTRIBUTE_VALUE)) {
            return new AttributeProperties(parent);
        }
        if (tag.equals(XML_NODE_REGISTERED_ATTRIBUTE_NAME)) {
            return new RegisteredAttributeProperties();
        }
        if (tag.equals(XML_NODE_ATTRIBUTE_REGISTRY)) {
            return parent;
        }
        return null;
    }

    @Override
    public void endElement(Object parent, String tag, Object userObject, XMLElement dom) {
        Attribute attribute;
        if (tag.equals(XML_NODE_REGISTERED_ATTRIBUTE_NAME)) {
            RegisteredAttributeProperties rap = (RegisteredAttributeProperties)userObject;
            if (rap.visible) {
                AttributeRegistry.getRegistry(this.getMap()).getElement((Comparable<?>)((Object)rap.attributeName)).setVisibility(true);
            }
            if (rap.restricted) {
                AttributeRegistry.getRegistry(this.getMap()).getElement((Comparable<?>)((Object)rap.attributeName)).setRestriction(true);
            }
            if (rap.manual) {
                AttributeRegistry.getRegistry(this.getMap()).getElement((Comparable<?>)((Object)rap.attributeName)).setManual(true);
            }
            return;
        }
        if (tag.equals(XML_NODE_REGISTERED_ATTRIBUTE_VALUE)) {
            AttributeProperties ap = (AttributeProperties)userObject;
            RegisteredAttributeProperties rap = (RegisteredAttributeProperties)ap.parent;
            attribute = new Attribute(rap.attributeName, ap.getValue());
            AttributeRegistry r = AttributeRegistry.getRegistry(this.getMap());
            r.registry(attribute);
        }
        if (parent instanceof NodeModel) {
            NodeModel node = (NodeModel)parent;
            if (tag.equals(XML_NODE_ATTRIBUTE)) {
                AttributeProperties ap = (AttributeProperties)userObject;
                attribute = new Attribute(ap.attributeName, ap.getValue());
                this.attributeController.createAttributeTableModel(node);
                NodeAttributeTableModel model = NodeAttributeTableModel.getModel(node);
                model.silentlyAddRowNoUndo(node, attribute);
                return;
            }
            return;
        }
    }

    private MapModel getMap() {
        return this.mapReader.getCurrentNodeTreeCreator().getCreatedMap();
    }

    private void registerAttributeHandlers(ReadManager reader) {
        reader.addAttributeHandler(XML_NODE_REGISTERED_ATTRIBUTE_NAME, "NAME", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                RegisteredAttributeProperties rap = (RegisteredAttributeProperties)userObject;
                rap.attributeName = value;
                AttributeRegistry.getRegistry(AttributeBuilder.this.getMap()).registry(value);
            }
        });
        reader.addAttributeHandler(XML_NODE_REGISTERED_ATTRIBUTE_NAME, "VISIBLE", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                RegisteredAttributeProperties rap = (RegisteredAttributeProperties)userObject;
                rap.visible = true;
            }
        });
        reader.addAttributeHandler(XML_NODE_REGISTERED_ATTRIBUTE_NAME, "RESTRICTED", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                RegisteredAttributeProperties rap = (RegisteredAttributeProperties)userObject;
                rap.restricted = true;
            }
        });
        reader.addAttributeHandler(XML_NODE_REGISTERED_ATTRIBUTE_NAME, "MANUAL", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                RegisteredAttributeProperties rap = (RegisteredAttributeProperties)userObject;
                rap.manual = true;
            }
        });
        reader.addAttributeHandler(XML_NODE_REGISTERED_ATTRIBUTE_VALUE, "VALUE", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                AttributeProperties ap = (AttributeProperties)userObject;
                ap.attributeValue = value;
            }
        });
        reader.addAttributeHandler(XML_NODE_REGISTERED_ATTRIBUTE_VALUE, "OBJECT", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                AttributeProperties ap = (AttributeProperties)userObject;
                ap.attributeObject = value;
            }
        });
        reader.addElementHandler(XML_NODE_ATTRIBUTE_LAYOUT, new IElementHandler(){

            @Override
            public Object createElement(Object parent, String tag, XMLElement attributes) {
                return parent;
            }
        });
        reader.addAttributeHandler(XML_NODE_ATTRIBUTE_LAYOUT, "NAME_WIDTH", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                AttributeBuilder.this.attributeController.createAttributeTableModel(node);
                AttributeTableLayoutModel layout = NodeAttributeTableModel.getModel(node).getLayout();
                layout.setColumnWidth(0, (Quantity<LengthUnit>)LengthUnit.fromStringInPt((String)value));
            }
        });
        reader.addAttributeHandler(XML_NODE_ATTRIBUTE_LAYOUT, "VALUE_WIDTH", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                NodeModel node = (NodeModel)userObject;
                AttributeBuilder.this.attributeController.createAttributeTableModel(node);
                AttributeTableLayoutModel layout = NodeAttributeTableModel.getModel(node).getLayout();
                layout.setColumnWidth(1, (Quantity<LengthUnit>)LengthUnit.fromStringInPt((String)value));
            }
        });
        reader.addAttributeHandler(XML_NODE_ATTRIBUTE, "NAME", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                AttributeProperties ap = (AttributeProperties)userObject;
                ap.attributeName = value;
            }
        });
        reader.addAttributeHandler(XML_NODE_ATTRIBUTE, "VALUE", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                AttributeProperties ap = (AttributeProperties)userObject;
                ap.attributeValue = value;
            }
        });
        reader.addAttributeHandler(XML_NODE_ATTRIBUTE, "OBJECT", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                AttributeProperties ap = (AttributeProperties)userObject;
                ap.attributeObject = value;
            }
        });
        reader.addAttributeHandler(XML_NODE_ATTRIBUTE_REGISTRY, "RESTRICTED", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                AttributeRegistry.getRegistry(AttributeBuilder.this.getMap()).setRestricted(true);
            }
        });
        reader.addAttributeHandler(XML_NODE_ATTRIBUTE_REGISTRY, "SHOW_ATTRIBUTES", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                AttributeRegistry attributes = AttributeRegistry.getRegistry(AttributeBuilder.this.getMap());
                if (attributes != null) {
                    attributes.setAttributeViewType(value);
                }
            }
        });
        reader.addAttributeHandler(XML_NODE_ATTRIBUTE_REGISTRY, "FONT_SIZE", new IAttributeHandler(){

            @Override
            public void setAttribute(Object userObject, String value) {
                int size = Integer.parseInt(value.toString());
                AttributeBuilder.this.getMap().addExtension(new FontSizeExtension(size));
            }
        });
    }

    public void registerBy(ReadManager reader, WriteManager writer) {
        reader.addElementHandler(XML_NODE_ATTRIBUTE_REGISTRY, this);
        reader.addElementHandler(XML_NODE_ATTRIBUTE, this);
        reader.addElementHandler(XML_NODE_REGISTERED_ATTRIBUTE_NAME, this);
        reader.addElementHandler(XML_NODE_REGISTERED_ATTRIBUTE_VALUE, this);
        writer.addExtensionElementWriter(NodeAttributeTableModel.class, new IExtensionElementWriter(){

            @Override
            public void writeContent(ITreeWriter writer, Object node, IExtension extension) throws IOException {
                NodeAttributeTableModel attributes = (NodeAttributeTableModel)extension;
                AttributeBuilder.this.save((NodeModel)node, attributes, writer);
            }
        });
        writer.addExtensionElementWriter(AttributeRegistry.class, new IExtensionElementWriter(){

            @Override
            public void writeContent(ITreeWriter writer, Object node, IExtension extension) throws IOException {
                AttributeRegistry attributes = (AttributeRegistry)extension;
                attributes.write(writer);
            }
        });
        writer.addAttributeWriter(XML_NODE_ATTRIBUTE_LAYOUT, AttributeWriter.INSTANCE);
        this.registerAttributeHandlers(reader);
    }

    void save(NodeModel node, NodeAttributeTableModel table, ITreeWriter writer) throws IOException {
        this.saveLayout(table.getLayout(), writer);
        if (table.getRowCount() > 0) {
            Vector<Attribute> attributes = table.getAttributes();
            for (int i = 0; i < attributes.size(); ++i) {
                this.saveAttribute(node, writer, table, attributes.get(i));
            }
        }
    }

    private void saveLayout(AttributeTableLayoutModel layout, ITreeWriter writer) throws IOException {
        if (layout != null) {
            boolean secondColumnHasOwnWidth;
            Quantity<LengthUnit> firstColumnWidth = layout.getColumnWidth(0);
            Quantity<LengthUnit> secondColumnWidth = layout.getColumnWidth(1);
            boolean firstColumnHasOwnWidth = !DEFAULT_COLUMN_WIDTH.equals(firstColumnWidth);
            boolean bl = secondColumnHasOwnWidth = !DEFAULT_COLUMN_WIDTH.equals(secondColumnWidth);
            if (firstColumnHasOwnWidth || secondColumnHasOwnWidth) {
                writer.addElement((Object)layout, XML_NODE_ATTRIBUTE_LAYOUT);
            }
        }
    }

    private void saveAttribute(NodeModel node, ITreeWriter writer, NodeAttributeTableModel attributes, Attribute attr) throws IOException {
        XMLElement attributeElement = new XMLElement();
        attributeElement.setName(XML_NODE_ATTRIBUTE);
        attributeElement.setAttribute("NAME", attr.getName());
        Object value = attr.getValue();
        boolean forceFormatting = Boolean.TRUE.equals(writer.getHint((Object)MapWriter.WriterHint.FORCE_FORMATTING));
        if (forceFormatting) {
            attributeElement.setAttribute("VALUE", TextController.getController().getTransformedTextNoThrow(node, attributes, value));
        } else {
            attributeElement.setAttribute("VALUE", value.toString());
            if (!(value instanceof String)) {
                attributeElement.setAttribute("OBJECT", TypeReference.toSpec(value));
            }
        }
        writer.addElement((Object)attr, attributeElement);
    }

    public void setAttributes(String tag, Object node, XMLElement attributes) {
    }

    static class AttributeProperties {
        Object parent;
        String attributeName;
        String attributeValue;
        String attributeObject;

        public AttributeProperties(Object parent) {
            this.parent = parent;
        }

        public Object getValue() {
            Object value;
            if (this.attributeObject == null) {
                value = this.attributeValue;
            } else {
                try {
                    value = TypeReference.create(this.attributeObject);
                }
                catch (Exception e) {
                    LogUtils.warn(e);
                    value = this.attributeValue;
                }
            }
            return value;
        }
    }

    static class RegisteredAttributeProperties {
        String attributeName;
        boolean manual = false;
        boolean restricted = false;
        boolean visible = false;

        RegisteredAttributeProperties() {
        }
    }

    static class AttributeWriter
    implements IAttributeWriter {
        static AttributeWriter INSTANCE = new AttributeWriter();

        AttributeWriter() {
        }

        @Override
        public void writeAttributes(ITreeWriter writer, Object userObject, String tag) {
            boolean secondColumnHasOwnWidth;
            AttributeTableLayoutModel layout = (AttributeTableLayoutModel)userObject;
            Quantity<LengthUnit> firstColumnWidth = layout.getColumnWidth(0);
            Quantity<LengthUnit> secondColumnWidth = layout.getColumnWidth(1);
            boolean firstColumnHasOwnWidth = !DEFAULT_COLUMN_WIDTH.equals(firstColumnWidth);
            boolean bl = secondColumnHasOwnWidth = !DEFAULT_COLUMN_WIDTH.equals(secondColumnWidth);
            if (firstColumnHasOwnWidth) {
                BackwardCompatibleQuantityWriter.forWriter(writer).writeQuantity("NAME_WIDTH", firstColumnWidth);
            }
            if (secondColumnHasOwnWidth) {
                BackwardCompatibleQuantityWriter.forWriter(writer).writeQuantity("VALUE_WIDTH", secondColumnWidth);
            }
        }
    }
}

