/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.explorer;

import java.awt.FontMetrics;
import java.util.List;
import javax.swing.Icon;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.explorer.AliasCondition;
import org.freeplane.features.filter.StringMatchingStrategy;
import org.freeplane.features.filter.condition.ConditionFactory;

class AliasStartsWithCondition
extends AliasCondition {
    static final String NAME = "alias_starts_with";
    private final StringMatchingStrategy stringMatchingStrategy;

    AliasStartsWithCondition(String alias, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics) {
        super(alias, matchCase, matchApproximately, ignoreDiacritics);
        this.stringMatchingStrategy = matchApproximately ? StringMatchingStrategy.DEFAULT_APPROXIMATE_STRING_MATCHING_STRATEGY : StringMatchingStrategy.EXACT_STRING_MATCHING_STRATEGY;
    }

    @Override
    protected boolean checkAlias(String alias) {
        String searchedAlias = this.getAlias();
        int searchedLength = searchedAlias.length();
        return alias.length() >= searchedLength && this.stringMatchingStrategy.matches(this.normalizedValue(), this.normalize(alias.substring(0, searchedLength)), StringMatchingStrategy.Type.ALL);
    }

    @Override
    protected String createDescription() {
        String condition = TextUtils.getText("filter_alias");
        String simpleCondition = TextUtils.getText(ConditionFactory.FILTER_STARTS_WITH);
        return this.createDescription(condition, simpleCondition, this.getAlias());
    }

    @Override
    protected List<Icon> createRenderedIcons(FontMetrics fontMetrics) {
        String condition = TextUtils.getText("filter_alias");
        return this.createRenderedIcons(condition, ConditionFactory.ConditionOperator.FILTER_STARTS_WITH, this.getAlias(), fontMetrics);
    }

    @Override
    protected String getName() {
        return NAME;
    }
}

