/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.freeplane.features.icon.IconGroup;
import org.freeplane.features.icon.IconNotFound;
import org.freeplane.features.icon.MindIcon;
import org.freeplane.features.icon.UIIcon;

public class IconStore {
    private final Map<String, IconGroup> groups = new LinkedHashMap<String, IconGroup>();
    private final Map<String, MindIcon> mindIcons = new LinkedHashMap<String, MindIcon>();
    private final Map<String, UIIcon> uiIcons = new HashMap<String, UIIcon>();
    public static final String EMOJI_GROUP = "emoji_group";

    public void addGroup(IconGroup group) {
        this.groups.put(group.getName(), group);
        this.addIcons(group);
    }

    public void addIcons(IconGroup group) {
        for (IconGroup subgroup : group.getGroups()) {
            if (subgroup.isLeaf()) {
                this.mindIcons.put(subgroup.getName(), subgroup.getGroupIcon());
                continue;
            }
            this.addIcons(subgroup);
        }
    }

    public void addUIIcon(UIIcon uiIcon) {
        this.uiIcons.put(uiIcon.getName(), uiIcon);
    }

    public Collection<IconGroup> getGroups() {
        return this.groups.values();
    }

    public Collection<MindIcon> getMindIcons() {
        return this.mindIcons.values();
    }

    public List<MindIcon> getUserIcons() {
        return this.groups.get("user").getIcons();
    }

    public MindIcon getMindIcon(String name) {
        MindIcon mindIcon;
        if (name == null) {
            return new IconNotFound(name);
        }
        if (this.containsMindIcon(name)) {
            return this.mindIcons.get(name);
        }
        if (name.startsWith("../") && (mindIcon = new MindIcon(name, Integer.MAX_VALUE)).getUrl() != null) {
            return mindIcon;
        }
        return new IconNotFound(name);
    }

    public boolean containsMindIcon(String name) {
        return this.mindIcons.containsKey(name);
    }

    public UIIcon getUIIcon(String name) {
        if (this.containsMindIcon(name)) {
            return this.mindIcons.get(name);
        }
        if (this.uiIcons.containsKey(name)) {
            return this.uiIcons.get(name);
        }
        return new IconNotFound(name);
    }
}

