/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon;

import java.awt.FontMetrics;
import java.util.List;
import javax.swing.Icon;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.StringMatchingStrategy;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionFactory;
import org.freeplane.features.icon.Tag;
import org.freeplane.features.icon.TagCondition;
import org.freeplane.n3.nanoxml.XMLElement;

public class TagContainsCondition
extends TagCondition {
    static final String NAME = "tag_contains_condition";
    static final String VALUE = "VALUE";
    private final String value;
    private final String comparedValue;
    private final StringMatchingStrategy stringMatchingStrategy;

    static ASelectableCondition load(XMLElement element) {
        return new TagContainsCondition(element.getAttribute(VALUE, null), Boolean.valueOf(element.getAttribute("MATCH_CASE", null)), Boolean.valueOf(element.getAttribute("MATCH_APPROXIMATELY", null)), Boolean.valueOf(element.getAttribute("MATCH_WORDWISE", null)), Boolean.valueOf(element.getAttribute("IGNORE_DIACRITICS", null)), Boolean.valueOf(element.getAttribute("SEARCH_ACROSS_ALL_CATEGORIES", null)));
    }

    public TagContainsCondition(String value, boolean matchCase, boolean matchApproximately, boolean matchWordwise, boolean ignoreDiacritics, boolean searchesAcrossAllCategories) {
        super(value, matchCase, matchApproximately, matchWordwise, ignoreDiacritics, searchesAcrossAllCategories);
        this.value = value;
        this.comparedValue = value;
        this.stringMatchingStrategy = matchApproximately ? StringMatchingStrategy.DEFAULT_APPROXIMATE_STRING_MATCHING_STRATEGY : StringMatchingStrategy.EXACT_STRING_MATCHING_STRATEGY;
    }

    @Override
    protected boolean checkShortTag(Tag tag, String tagCategorySeparator) {
        return this.checkText(tag.withoutCategories(tagCategorySeparator).getContent());
    }

    @Override
    protected boolean checkCategorizedTag(Tag categorizedTag, String tagCategorySeparatorForMap) {
        return this.checkText(categorizedTag.getContent());
    }

    @Override
    protected boolean checkText(String text) {
        return this.stringMatchingStrategy.matches(this.normalizedValue(), this.normalize(text), this.substringMatchType());
    }

    @Override
    protected String createDescription() {
        String simpleCondition = TextUtils.getText(this.matchWordwise ? ConditionFactory.FILTER_CONTAINS_WORDWISE : ConditionFactory.FILTER_CONTAINS);
        return this.createDescription(TextUtils.getText("filter_tag"), simpleCondition, this.value);
    }

    @Override
    protected List<Icon> createRenderedIcons(FontMetrics fontMetrics) {
        String operator = (this.matchWordwise ? ConditionFactory.ConditionOperator.FILTER_CONTAINS_WORDWISE : ConditionFactory.ConditionOperator.FILTER_CONTAINS).getOpeningValueDelimiter();
        return this.createRenderedIcons("", ConditionFactory.ConditionOperator.EMPTY, this.tagIcon(operator + this.value + operator, fontMetrics), fontMetrics);
    }

    @Override
    public void fillXML(XMLElement child) {
        super.fillXML(child);
        child.setAttribute(VALUE, this.value);
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    protected String conditionValue() {
        return this.comparedValue;
    }
}

