/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.awt.FontMetrics;
import java.util.List;
import javax.swing.Icon;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.ConditionSnapshotFactory;
import org.freeplane.features.map.CloneOfSelectedViewSnapshotCondition;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

public class CloneOfSelectedViewCondition
extends ASelectableCondition
implements ConditionSnapshotFactory {
    static final String NAME = "clone_condition";
    private static String description;

    public static ASelectableCondition createCondition() {
        return new CloneOfSelectedViewCondition();
    }

    @Override
    public boolean checkNode(NodeModel node) {
        IMapSelection selection = Controller.getCurrentController().getSelection();
        if (selection != null) {
            for (NodeModel clone : node.allClones()) {
                if (!selection.isSelected(clone)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected String createDescription() {
        if (description == null) {
            description = TextUtils.getText("filter_clones");
        }
        return description;
    }

    @Override
    protected List<Icon> createRenderedIcons(FontMetrics fontMetrics) {
        return this.createRenderedIconsFromDescription(fontMetrics);
    }

    @Override
    protected String getName() {
        return NAME;
    }

    @Override
    public boolean canBePersisted() {
        return false;
    }

    @Override
    public ASelectableCondition createSnapshotCondition() {
        return new CloneOfSelectedViewSnapshotCondition(Controller.getCurrentController().getSelection().getSelection());
    }
}

