/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.awt.event.ActionEvent;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.explorer.MapExplorerController;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

public class GotoNodeAction
extends AFreeplaneAction {
    private static final long serialVersionUID = 1L;

    public GotoNodeAction() {
        super("GotoNodeAction");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Controller controller = Controller.getCurrentController();
        IMapSelection selection = controller.getSelection();
        NodeModel node = selection.getSelected();
        String reference = UITools.showInputDialog(node, TextUtils.getText("enter_node_id_or_reference"), (String)this.getValue("Name"), 3);
        if (reference == null || "".equals(reference)) {
            return;
        }
        MapExplorerController explorer = Controller.getCurrentModeController().getExtension(MapExplorerController.class);
        NodeModel dest = explorer.getNodeAt(node, reference.startsWith("ID_") || reference.startsWith("at(") || node.getMap().getNodeForID(reference) != null ? reference : "at(" + reference + ")");
        if (dest == null) {
            return;
        }
        controller.getModeController().getMapController().displayNode(dest);
        selection.selectAsTheOnlyOneSelected(dest);
    }
}

