/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.nodelocation;

import java.util.Collection;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.io.ReadManager;
import org.freeplane.core.io.WriteManager;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ExclusivePropertyChain;
import org.freeplane.features.mode.IPropertyHandler;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodelocation.LocationBuilder;
import org.freeplane.features.nodelocation.LocationModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapStyleModel;

public class LocationController
implements IExtension {
    private final ExclusivePropertyChain<Quantity<LengthUnit>, NodeModel> childVGapHandlers;
    private final ExclusivePropertyChain<Quantity<LengthUnit>, NodeModel> childHGapHandlers;

    public static LocationController getController() {
        ModeController modeController = Controller.getCurrentModeController();
        return LocationController.getController(modeController);
    }

    public static LocationController getController(ModeController modeController) {
        return modeController.getExtension(LocationController.class);
    }

    public static void install(LocationController locationController) {
        ModeController modeController = Controller.getCurrentModeController();
        modeController.addExtension(LocationController.class, locationController);
    }

    public LocationController() {
        ModeController modeController = Controller.getCurrentModeController();
        MapController mapController = modeController.getMapController();
        ReadManager readManager = mapController.getReadManager();
        WriteManager writeManager = mapController.getWriteManager();
        LocationBuilder locationBuilder = new LocationBuilder();
        locationBuilder.registerBy(readManager, writeManager);
        this.childVGapHandlers = new ExclusivePropertyChain();
        this.childHGapHandlers = new ExclusivePropertyChain();
        this.childVGapHandlers.addGetter(IPropertyHandler.STYLE, (node, option, currentValue) -> {
            MapModel map = node.getMap();
            LogicalStyleController styleController = LogicalStyleController.getController(modeController);
            Collection<IStyle> style = styleController.getStyles((NodeModel)node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            Quantity<LengthUnit> returnedGap = this.getStyleChildVGap(map, style);
            return returnedGap;
        });
        this.childVGapHandlers.addGetter(IPropertyHandler.DEFAULT, (node, option, currentValue) -> LocationModel.DEFAULT_VGAP);
        this.childHGapHandlers.addGetter(IPropertyHandler.STYLE, (node, option, currentValue) -> {
            MapModel map = node.getMap();
            LogicalStyleController styleController = LogicalStyleController.getController(modeController);
            Collection<IStyle> style = styleController.getStyles((NodeModel)node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            Quantity<LengthUnit> returnedGap = this.getStyleCommonChildHGap(map, style);
            return returnedGap;
        });
        this.childHGapHandlers.addGetter(IPropertyHandler.DEFAULT, (node, option, currentValue) -> LocationModel.DEFAULT_HGAP);
    }

    private Quantity<LengthUnit> getStyleChildVGap(MapModel map, Collection<IStyle> styleKeys) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : styleKeys) {
            Quantity<LengthUnit> vGap;
            LocationModel styleModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (styleModel = styleNode.getExtension(LocationModel.class)) == null || (vGap = styleModel.getVGap()) == LocationModel.DEFAULT_VGAP) continue;
            return vGap;
        }
        return null;
    }

    private Quantity<LengthUnit> getStyleCommonChildHGap(MapModel map, Collection<IStyle> styleKeys) {
        MapStyleModel model = MapStyleModel.getExtension(map);
        for (IStyle styleKey : styleKeys) {
            Quantity<LengthUnit> gap;
            LocationModel styleModel;
            NodeModel styleNode = model.getStyleNode(styleKey);
            if (styleNode == null || (styleModel = styleNode.getExtension(LocationModel.class)) == null || (gap = styleModel.getBaseHGap()) == LocationModel.DEFAULT_HGAP) continue;
            return gap;
        }
        return null;
    }

    public Quantity<LengthUnit> getHorizontalShift(NodeModel node) {
        return LocationModel.getModel(node).getHGap();
    }

    public Quantity<LengthUnit> getVerticalShift(NodeModel node) {
        return LocationModel.getModel(node).getShiftY();
    }

    public Quantity<LengthUnit> getCommonVGapBetweenChildren(NodeModel node) {
        return this.childVGapHandlers.getProperty(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
    }

    public Quantity<LengthUnit> getBaseHGapToChildren(NodeModel node) {
        return this.childHGapHandlers.getProperty(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
    }
}

