/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles;

import java.awt.event.ActionEvent;
import org.freeplane.core.ui.AFreeplaneAction;
import org.freeplane.core.ui.EnabledAction;
import org.freeplane.core.ui.SelectableAction;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.styles.MapStyle;

@SelectableAction(checkOnNodeChange=true)
@EnabledAction(checkOnNodeChange=true)
public class SetStringMapPropertyAction
extends AFreeplaneAction {
    private String propertyName;
    private String propertyValue;
    private String property;

    public SetStringMapPropertyAction(String property) {
        super("SetStringMapPropertyAction." + property, TextUtils.getRawText("MapProperty." + property), null);
        this.property = property;
        int separator = property.indexOf(46);
        this.propertyName = property.substring(0, separator);
        this.propertyValue = property.substring(separator + 1);
        this.setIcon(property + ".icon");
        this.setTooltip(this.getTooltipKey());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Controller controller = Controller.getCurrentController();
        NodeModel node = controller.getSelection().getSelected();
        ModeController modeController = controller.getModeController();
        MapStyle mapStyleController = MapStyle.getController(modeController);
        MapModel map = node.getMap();
        mapStyleController.setProperty(map, this.propertyName, this.propertyValue);
        this.setSelected(true);
    }

    @Override
    public String getTextKey() {
        return "OptionPanel." + this.property;
    }

    @Override
    public String getTooltipKey() {
        return this.getTextKey() + ".tooltip";
    }

    @Override
    public void setSelected() {
        try {
            Controller controller = Controller.getCurrentController();
            NodeModel node = controller.getSelection().getSelected();
            ModeController modeController = controller.getModeController();
            MapStyle mapStyleController = MapStyle.getController(modeController);
            String value = mapStyleController.getPropertySetDefault(node.getMap(), this.propertyName);
            boolean isSet = this.propertyValue.equals(value);
            this.setSelected(isSet);
        }
        catch (Exception e) {
            this.setSelected(false);
        }
    }

    @Override
    public void setEnabled() {
        Controller controller = Controller.getCurrentController();
        this.setEnabled(controller.getSelection() != null);
    }
}

