/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.n3.nanoxml;

import java.io.IOException;
import java.io.Reader;
import org.freeplane.n3.nanoxml.IXMLReader;

class PIReader
extends Reader {
    private boolean atEndOfData;
    private IXMLReader reader;

    PIReader(IXMLReader reader) {
        this.reader = reader;
        this.atEndOfData = false;
    }

    @Override
    public void close() throws IOException {
        while (!this.atEndOfData) {
            char ch2;
            char ch = this.reader.read();
            if (ch != '?' || (ch2 = this.reader.read()) != '>') continue;
            this.atEndOfData = true;
        }
    }

    protected void finalize() throws Throwable {
        this.reader = null;
        super.finalize();
    }

    @Override
    public int read(char[] buffer, int offset, int size) throws IOException {
        if (this.atEndOfData) {
            return -1;
        }
        int charsRead = 0;
        if (offset + size > buffer.length) {
            size = buffer.length - offset;
        }
        while (charsRead < size) {
            char ch = this.reader.read();
            if (ch == '?') {
                char ch2 = this.reader.read();
                if (ch2 == '>') {
                    this.atEndOfData = true;
                    break;
                }
                this.reader.unread(ch2);
            }
            buffer[charsRead] = ch;
            ++charsRead;
        }
        if (charsRead == 0) {
            charsRead = -1;
        }
        return charsRead;
    }
}

