/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Vector;
import javax.swing.Timer;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.undo.IActor;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.IMapLifeCycleListener;
import org.freeplane.features.map.INodeView;
import org.freeplane.features.map.MapChangeEvent;
import org.freeplane.features.map.MapController;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeDeletionEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.NodeHookDescriptor;
import org.freeplane.features.mode.PersistentNodeHook;
import org.freeplane.features.ui.INodeViewVisitor;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.NodeView;

@NodeHookDescriptor(hookName="accessories/plugins/BlinkingNodeHook.properties", onceForMap=false)
public class BlinkingNodeHook
extends PersistentNodeHook {
    static Vector<Color> colors = new Vector();

    @Override
    protected IExtension createExtension(NodeModel node, XMLElement element) {
        return new TimerColorChanger(node);
    }

    protected Class<TimerColorChanger> getExtensionClass() {
        return TimerColorChanger.class;
    }

    @Override
    public void remove(NodeModel node, IExtension extension) {
        TimerColorChanger timer = (TimerColorChanger)extension;
        timer.getTimer().stop();
        MapController mapController = Controller.getCurrentModeController().getMapController();
        mapController.removeMapChangeListener(timer);
        mapController.removeMapLifeCycleListener(timer);
        super.remove(node, extension);
    }

    protected class TimerColorChanger
    implements IExtension,
    IMapChangeListener,
    IMapLifeCycleListener,
    ActionListener {
        private final NodeModel node;
        private final Timer timer;

        TimerColorChanger(NodeModel node) {
            this.node = node;
            MapController mapController = Controller.getCurrentModeController().getMapController();
            mapController.addUIMapChangeListener(this);
            mapController.addMapLifeCycleListener(this);
            colors.clear();
            colors.add(Color.BLUE);
            colors.add(Color.RED);
            colors.add(Color.MAGENTA);
            colors.add(Color.CYAN);
            this.timer = new Timer(500, this);
            this.timer.start();
        }

        public Iterable<NodeModel> getNodes() {
            return this.node != null ? this.node.allClones() : Collections.emptyList();
        }

        public Timer getTimer() {
            return this.timer;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Iterable<NodeModel> nodes = this.getNodes();
            if (Controller.getCurrentModeController().isBlocked()) {
                return;
            }
            for (NodeModel node : nodes) {
                node.acceptViewVisitor(new INodeViewVisitor(){

                    @Override
                    public void visit(INodeView nodeView) {
                        if (!(nodeView instanceof NodeView)) {
                            return;
                        }
                        MainView container = ((NodeView)nodeView).getMainView();
                        if (container == null || !container.isVisible()) {
                            return;
                        }
                        Color col = container.getForeground();
                        int index = -1;
                        if (col != null && colors.contains(col)) {
                            index = colors.indexOf(col);
                        }
                        if (++index >= colors.size()) {
                            index = 0;
                        }
                        ((Component)container).setForeground(colors.get(index));
                    }
                });
            }
        }

        @Override
        public void mapChanged(MapChangeEvent event) {
        }

        @Override
        public void onNodeDeleted(NodeDeletionEvent nodeDeletionEvent) {
            if (this.node.getMap().isUndoActionRunning() || !this.node.equals(nodeDeletionEvent.node) && !this.node.isDescendantOf(nodeDeletionEvent.node)) {
                return;
            }
            IActor actor = new IActor(){

                @Override
                public boolean isReadonly() {
                    return true;
                }

                @Override
                public void act() {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            BlinkingNodeHook.this.remove(TimerColorChanger.this.node, TimerColorChanger.this.node.getExtension(TimerColorChanger.class));
                        }
                    });
                }

                @Override
                public String getDescription() {
                    return "BlinkingNodeHook.timer";
                }

                @Override
                public void undo() {
                    TimerColorChanger.this.node.addExtension(new TimerColorChanger(TimerColorChanger.this.node));
                }
            };
            Controller.getCurrentModeController().execute(actor, this.node.getMap());
        }

        @Override
        public void onRemove(MapModel map) {
            if (this.node.getMap().equals(map)) {
                this.timer.stop();
                MapController mapController = Controller.getCurrentModeController().getMapController();
                mapController.removeMapChangeListener(this);
                mapController.removeMapLifeCycleListener(this);
            }
        }
    }
}

