/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Component;
import java.awt.Insets;
import javax.swing.border.EmptyBorder;

public class ZoomedEmptyBorder
extends EmptyBorder {
    private static final long serialVersionUID = 1L;
    private final IntToIntFunction zoomFunction;

    public ZoomedEmptyBorder(Insets borderInsets, IntToIntFunction zoomFunction) {
        super(borderInsets);
        this.zoomFunction = zoomFunction;
    }

    public ZoomedEmptyBorder(int top, int left, int bottom, int right, IntToIntFunction zoomFunction) {
        super(top, left, bottom, right);
        this.zoomFunction = zoomFunction;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return this.zoom(super.getBorderInsets(c, insets));
    }

    private Insets zoom(Insets insets) {
        if (insets.left != 0) {
            insets.left = this.zoomFunction.applyAsInt(insets.left);
        }
        if (insets.right != 0) {
            insets.right = this.zoomFunction.applyAsInt(insets.right);
        }
        if (insets.top != 0) {
            insets.top = this.zoomFunction.applyAsInt(insets.top);
        }
        if (insets.bottom != 0) {
            insets.bottom = this.zoomFunction.applyAsInt(insets.bottom);
        }
        return insets;
    }

    @Override
    public Insets getBorderInsets() {
        return this.zoom(super.getBorderInsets());
    }

    @FunctionalInterface
    public static interface IntToIntFunction {
        public int applyAsInt(long var1);
    }
}

