/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.importer;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.base.HasDescription;
import com.tngtech.archunit.base.MayResolveTypesViaReflection;
import com.tngtech.archunit.core.domain.JavaAnnotation;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaClassDescriptor;
import com.tngtech.archunit.core.domain.JavaEnumConstant;
import com.tngtech.archunit.core.domain.JavaField;
import com.tngtech.archunit.core.domain.JavaModifier;
import com.tngtech.archunit.core.importer.DeclarationHandler;
import com.tngtech.archunit.core.importer.DomainBuilders;
import com.tngtech.archunit.core.importer.ImportedClasses;
import com.tngtech.archunit.core.importer.JavaClassDescriptorImporter;
import com.tngtech.archunit.core.importer.JavaClassSignatureImporter;
import com.tngtech.archunit.core.importer.JavaCodeUnitSignatureImporter;
import com.tngtech.archunit.core.importer.JavaFieldTypeSignatureImporter;
import com.tngtech.archunit.core.importer.RawAccessRecord;
import com.tngtech.archunit.core.importer.SourceDescriptor;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;
import com.tngtech.archunit.thirdparty.com.google.common.base.Strings;
import com.tngtech.archunit.thirdparty.com.google.common.collect.HashMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.SetMultimap;
import com.tngtech.archunit.thirdparty.com.google.common.primitives.Booleans;
import com.tngtech.archunit.thirdparty.com.google.common.primitives.Bytes;
import com.tngtech.archunit.thirdparty.com.google.common.primitives.Chars;
import com.tngtech.archunit.thirdparty.com.google.common.primitives.Doubles;
import com.tngtech.archunit.thirdparty.com.google.common.primitives.Floats;
import com.tngtech.archunit.thirdparty.com.google.common.primitives.Ints;
import com.tngtech.archunit.thirdparty.com.google.common.primitives.Longs;
import com.tngtech.archunit.thirdparty.com.google.common.primitives.Shorts;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.AnnotationVisitor;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.ClassVisitor;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.FieldVisitor;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.Handle;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.Label;
import com.tngtech.archunit.thirdparty.org.objectweb.asm.MethodVisitor;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JavaClassProcessor
extends ClassVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(JavaClassProcessor.class);
    private static final AccessHandler NO_OP = new AccessHandler.NoOp();
    private DomainBuilders.JavaClassBuilder javaClassBuilder;
    private final Set<DomainBuilders.JavaAnnotationBuilder> annotations = new HashSet<DomainBuilders.JavaAnnotationBuilder>();
    private final SourceDescriptor sourceDescriptor;
    private final DeclarationHandler declarationHandler;
    private final AccessHandler accessHandler;
    private String className;

    JavaClassProcessor(SourceDescriptor sourceDescriptor, DeclarationHandler declarationHandler) {
        this(sourceDescriptor, declarationHandler, NO_OP);
    }

    JavaClassProcessor(SourceDescriptor sourceDescriptor, DeclarationHandler declarationHandler, AccessHandler accessHandler) {
        super(589824);
        this.sourceDescriptor = sourceDescriptor;
        this.declarationHandler = declarationHandler;
        this.accessHandler = accessHandler;
    }

    Optional<JavaClass> createJavaClass() {
        return this.javaClassBuilder != null ? Optional.of(this.javaClassBuilder.build()) : Optional.empty();
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        LOG.debug("Processing class '{}'", (Object)name);
        JavaClassDescriptor descriptor = JavaClassDescriptorImporter.createFromAsmObjectTypeName(name);
        if (this.alreadyImported(descriptor)) {
            return;
        }
        List<String> interfaceNames = this.createInterfaceNames(interfaces);
        LOG.trace("Found interfaces {} on class '{}'", interfaceNames, (Object)name);
        boolean opCodeForInterfaceIsPresent = (access & 0x200) != 0;
        boolean opCodeForEnumIsPresent = (access & 0x4000) != 0;
        boolean opCodeForAnnotationIsPresent = (access & 0x2000) != 0;
        boolean opCodeForRecordIsPresent = (access & 0x10000) != 0;
        Optional<String> superclassName = this.getSuperclassName(superName, opCodeForInterfaceIsPresent);
        LOG.trace("Found superclass {} on class '{}'", superclassName.orElse(null), (Object)name);
        this.javaClassBuilder = new DomainBuilders.JavaClassBuilder().withSourceDescriptor(this.sourceDescriptor).withDescriptor(descriptor).withInterface(opCodeForInterfaceIsPresent).withEnum(opCodeForEnumIsPresent).withAnnotation(opCodeForAnnotationIsPresent).withModifiers(JavaModifier.getModifiersForClass(access)).withRecord(opCodeForRecordIsPresent);
        this.className = descriptor.getFullyQualifiedClassName();
        this.declarationHandler.onNewClass(this.className, superclassName, interfaceNames);
        JavaClassSignatureImporter.parseAsmTypeSignature(signature, this.declarationHandler);
    }

    private boolean alreadyImported(JavaClassDescriptor descriptor) {
        return !this.declarationHandler.isNew(descriptor.getFullyQualifiedClassName());
    }

    private Optional<String> getSuperclassName(String superName, boolean isInterface) {
        return superName != null && !isInterface ? Optional.of(this.createTypeName(superName)) : Optional.empty();
    }

    private boolean importAborted() {
        return this.javaClassBuilder == null;
    }

    @Override
    public void visitSource(String source, String debug) {
        if (!this.importAborted() && source != null) {
            this.javaClassBuilder.withSourceFileName(source);
        }
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (this.importAborted()) {
            return;
        }
        String innerTypeName = this.createTypeName(name);
        if (!this.visitingCurrentClass(innerTypeName)) {
            return;
        }
        this.javaClassBuilder.withSimpleName(Strings.nullToEmpty(innerName));
        boolean isAnonymousClass = innerName == null;
        this.javaClassBuilder.withAnonymousClass(isAnonymousClass);
        boolean isMemberClass = outerName != null;
        this.javaClassBuilder.withMemberClass(isMemberClass);
        if (isMemberClass) {
            this.javaClassBuilder.withModifiers(JavaModifier.getModifiersForClass(access));
            this.declarationHandler.registerEnclosingClass(innerTypeName, this.createTypeName(outerName));
        }
    }

    private boolean visitingCurrentClass(String innerTypeName) {
        return innerTypeName.equals(this.className);
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        if (this.importAborted()) {
            return;
        }
        this.declarationHandler.registerEnclosingClass(this.className, this.createTypeName(owner));
        if (name != null && desc != null) {
            JavaClassDescriptor ownerType = JavaClassDescriptorImporter.createFromAsmObjectTypeName(owner);
            RawAccessRecord.CodeUnit codeUnit = new RawAccessRecord.CodeUnit(name, desc, ownerType.getFullyQualifiedClassName());
            this.declarationHandler.registerEnclosingCodeUnit(this.className, codeUnit);
        }
    }

    private List<String> createInterfaceNames(String[] interfaces) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (String i : interfaces) {
            result.add(this.createTypeName(i));
        }
        return result.build();
    }

    private String createTypeName(String name) {
        return name.replace("/", ".");
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.importAborted()) {
            return super.visitField(access, name, desc, signature, value);
        }
        JavaClassDescriptor rawType = JavaClassDescriptorImporter.importAsmTypeFromDescriptor(desc);
        Optional<DomainBuilders.JavaTypeCreationProcess<JavaField>> genericType = JavaFieldTypeSignatureImporter.parseAsmFieldTypeSignature(signature, this.declarationHandler);
        DomainBuilders.JavaFieldBuilder fieldBuilder = (DomainBuilders.JavaFieldBuilder)((DomainBuilders.JavaFieldBuilder)((DomainBuilders.JavaFieldBuilder)new DomainBuilders.JavaFieldBuilder().withName(name)).withType(genericType, rawType).withModifiers(JavaModifier.getModifiersForField(access))).withDescriptor(desc);
        this.declarationHandler.onDeclaredField(fieldBuilder, rawType.getFullyQualifiedClassName());
        return new FieldProcessor(fieldBuilder, this.declarationHandler);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.importAborted()) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        LOG.trace("Analyzing method {}.{}:{}", new Object[]{this.className, name, desc});
        RawAccessRecord.CodeUnit codeUnit = new RawAccessRecord.CodeUnit(name, desc, this.className);
        this.accessHandler.setContext(codeUnit);
        JavaClassDescriptor rawReturnType = JavaClassDescriptorImporter.importAsmMethodReturnType(desc);
        DomainBuilders.JavaCodeUnitBuilder<?, ?> codeUnitBuilder = this.addCodeUnitBuilder(name, codeUnit.getRawParameterTypeNames(), rawReturnType.getFullyQualifiedClassName());
        JavaCodeUnitSignatureImporter.JavaCodeUnitSignature codeUnitSignature = JavaCodeUnitSignatureImporter.parseAsmMethodSignature(signature, this.declarationHandler);
        List<JavaClassDescriptor> throwsDeclarations = this.typesFrom(exceptions);
        ((DomainBuilders.JavaCodeUnitBuilder)((DomainBuilders.JavaMemberBuilder)((DomainBuilders.JavaCodeUnitBuilder)((DomainBuilders.JavaCodeUnitBuilder)((DomainBuilders.JavaCodeUnitBuilder)((DomainBuilders.JavaCodeUnitBuilder)codeUnitBuilder.withName(name)).withModifiers(JavaModifier.getModifiersForMethod(access))).withTypeParameters(codeUnitSignature.getTypeParameterBuilders())).withParameterTypes(codeUnitSignature.getParameterTypes(), codeUnit.getRawParameterTypes())).withReturnType(codeUnitSignature.getReturnType(), rawReturnType)).withDescriptor(desc)).withThrowsClause(throwsDeclarations);
        this.declarationHandler.onDeclaredThrowsClause(this.fullyQualifiedClassNamesOf(throwsDeclarations));
        return new MethodProcessor(this.className, this.accessHandler, codeUnitBuilder, this.declarationHandler);
    }

    private Collection<String> fullyQualifiedClassNamesOf(List<JavaClassDescriptor> classDescriptors) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (JavaClassDescriptor classDescriptor : classDescriptors) {
            result.add(classDescriptor.getFullyQualifiedClassName());
        }
        return result.build();
    }

    private List<JavaClassDescriptor> typesFrom(String[] throwsDeclarations) {
        return throwsDeclarations != null ? Arrays.stream(throwsDeclarations).map(JavaClassDescriptorImporter::createFromAsmObjectTypeName).collect(Collectors.toList()) : Collections.emptyList();
    }

    private DomainBuilders.JavaCodeUnitBuilder<?, ?> addCodeUnitBuilder(String name, Collection<String> rawParameterTypeNames, String rawReturnTypeName) {
        if ("<init>".equals(name)) {
            DomainBuilders.JavaConstructorBuilder builder = new DomainBuilders.JavaConstructorBuilder();
            this.declarationHandler.onDeclaredConstructor(builder, rawParameterTypeNames);
            return builder;
        }
        if ("<clinit>".equals(name)) {
            DomainBuilders.JavaStaticInitializerBuilder builder = new DomainBuilders.JavaStaticInitializerBuilder();
            this.declarationHandler.onDeclaredStaticInitializer(builder);
            return builder;
        }
        DomainBuilders.JavaMethodBuilder builder = new DomainBuilders.JavaMethodBuilder();
        this.declarationHandler.onDeclaredMethod(builder, rawParameterTypeNames, rawReturnTypeName);
        return builder;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (this.importAborted()) {
            return super.visitAnnotation(desc, visible);
        }
        return new AnnotationProcessor(this.annotations::add, this.declarationHandler, JavaClassProcessor.handleAnnotationAnnotationProperty(desc, this.declarationHandler));
    }

    @Override
    public void visitEnd() {
        if (this.importAborted()) {
            return;
        }
        this.declarationHandler.onDeclaredClassAnnotations(this.annotations);
        LOG.trace("Done analyzing {}", (Object)this.className);
    }

    private static TakesAnnotationBuilder addAnnotationAtIndex(SetMultimap<Integer, DomainBuilders.JavaAnnotationBuilder> annotations, int index) {
        return annotation -> annotations.put(index, annotation);
    }

    private static TakesAnnotationBuilder addAnnotationAsProperty(String name, DomainBuilders.JavaAnnotationBuilder annotationBuilder) {
        return builder -> annotationBuilder.addProperty(name, DomainBuilders.JavaAnnotationBuilder.ValueBuilder.fromAnnotationProperty(builder));
    }

    private static DomainBuilders.JavaAnnotationBuilder.ValueBuilder handleAnnotationClassProperty(JavaClassDescriptor clazz, DeclarationHandler declarationHandler) {
        declarationHandler.onDeclaredAnnotationValueType(clazz.getFullyQualifiedClassName());
        return DomainBuilders.JavaAnnotationBuilder.ValueBuilder.fromClassProperty(clazz);
    }

    private static DomainBuilders.JavaAnnotationBuilder.ValueBuilder handleAnnotationEnumProperty(String desc, String value, DeclarationHandler declarationHandler) {
        JavaClassDescriptor enumType = JavaClassDescriptorImporter.importAsmTypeFromDescriptor(desc);
        declarationHandler.onDeclaredAnnotationValueType(enumType.getFullyQualifiedClassName());
        return DomainBuilders.JavaAnnotationBuilder.ValueBuilder.fromEnumProperty(enumType, value);
    }

    private static DomainBuilders.JavaAnnotationBuilder handleAnnotationAnnotationProperty(String desc, DeclarationHandler declarationHandler) {
        DomainBuilders.JavaAnnotationBuilder subAnnotationBuilder = new DomainBuilders.JavaAnnotationBuilder().withType(JavaClassDescriptorImporter.importAsmTypeFromDescriptor(desc));
        declarationHandler.onDeclaredAnnotationValueType(subAnnotationBuilder.getFullyQualifiedClassName());
        return subAnnotationBuilder;
    }

    private static interface TakesAnnotationBuilder {
        public void add(DomainBuilders.JavaAnnotationBuilder var1);
    }

    static interface AccessHandler {
        public void handleFieldInstruction(int var1, String var2, String var3, String var4);

        public void setContext(RawAccessRecord.CodeUnit var1);

        public void onLineNumber(int var1, Label var2);

        public void onLabel(Label var1);

        public void handleMethodInstruction(String var1, String var2, String var3);

        public void handleMethodReferenceInstruction(String var1, String var2, String var3);

        public void handleLambdaInstruction(String var1, String var2, String var3);

        public void handleReferencedClassObject(JavaClassDescriptor var1, int var2);

        public void handleInstanceofCheck(JavaClassDescriptor var1, int var2);

        public void handleTryCatchBlock(Label var1, Label var2, Label var3, JavaClassDescriptor var4);

        public void handleTryFinallyBlock(Label var1, Label var2, Label var3);

        public void onMethodEnd();

        @Internal
        public static class NoOp
        implements AccessHandler {
            @Override
            public void handleFieldInstruction(int opcode, String owner, String name, String desc) {
            }

            @Override
            public void setContext(RawAccessRecord.CodeUnit codeUnit) {
            }

            @Override
            public void onLineNumber(int lineNumber, Label label) {
            }

            @Override
            public void onLabel(Label label) {
            }

            @Override
            public void handleMethodInstruction(String owner, String name, String desc) {
            }

            @Override
            public void handleMethodReferenceInstruction(String owner, String name, String desc) {
            }

            @Override
            public void handleLambdaInstruction(String owner, String name, String desc) {
            }

            @Override
            public void handleReferencedClassObject(JavaClassDescriptor type, int lineNumber) {
            }

            @Override
            public void handleInstanceofCheck(JavaClassDescriptor instanceOfCheckType, int lineNumber) {
            }

            @Override
            public void handleTryCatchBlock(Label start, Label end, Label handler, JavaClassDescriptor throwableType) {
            }

            @Override
            public void handleTryFinallyBlock(Label start, Label end, Label handler) {
            }

            @Override
            public void onMethodEnd() {
            }
        }
    }

    private static class FieldProcessor
    extends FieldVisitor {
        private final DomainBuilders.JavaFieldBuilder fieldBuilder;
        private final DeclarationHandler declarationHandler;
        private final Set<DomainBuilders.JavaAnnotationBuilder> annotations = new HashSet<DomainBuilders.JavaAnnotationBuilder>();

        private FieldProcessor(DomainBuilders.JavaFieldBuilder fieldBuilder, DeclarationHandler declarationHandler) {
            super(589824);
            this.fieldBuilder = fieldBuilder;
            this.declarationHandler = declarationHandler;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationProcessor(this.annotations::add, this.declarationHandler, JavaClassProcessor.handleAnnotationAnnotationProperty(desc, this.declarationHandler));
        }

        @Override
        public void visitEnd() {
            this.declarationHandler.onDeclaredMemberAnnotations(this.fieldBuilder.getName(), this.fieldBuilder.getDescriptor(), this.annotations);
        }
    }

    private static class MethodProcessor
    extends MethodVisitor {
        private final String declaringClassName;
        private final AccessHandler accessHandler;
        private final DomainBuilders.JavaCodeUnitBuilder<?, ?> codeUnitBuilder;
        private final DeclarationHandler declarationHandler;
        private final Set<DomainBuilders.JavaAnnotationBuilder> annotations = new HashSet<DomainBuilders.JavaAnnotationBuilder>();
        private final SetMultimap<Integer, DomainBuilders.JavaAnnotationBuilder> parameterAnnotationsByIndex = HashMultimap.create();
        private int actualLineNumber;

        MethodProcessor(String declaringClassName, AccessHandler accessHandler, DomainBuilders.JavaCodeUnitBuilder<?, ?> codeUnitBuilder, DeclarationHandler declarationHandler) {
            super(589824);
            this.declaringClassName = declaringClassName;
            this.accessHandler = accessHandler;
            this.codeUnitBuilder = codeUnitBuilder;
            this.declarationHandler = declarationHandler;
            codeUnitBuilder.withParameterAnnotations(this.parameterAnnotationsByIndex);
        }

        @Override
        public void visitCode() {
            this.actualLineNumber = 0;
        }

        @Override
        public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return new AnnotationProcessor(JavaClassProcessor.addAnnotationAtIndex(this.parameterAnnotationsByIndex, parameter), this.declarationHandler, JavaClassProcessor.handleAnnotationAnnotationProperty(desc, this.declarationHandler));
        }

        @Override
        public void visitLineNumber(int line, Label label) {
            LOG.trace("Examining line number {} at label {}", (Object)line, (Object)label);
            this.codeUnitBuilder.recordLineNumber(line);
            this.actualLineNumber = line;
            this.accessHandler.onLineNumber(this.actualLineNumber, label);
        }

        @Override
        public void visitLabel(Label label) {
            LOG.trace("Examining label {}", (Object)label);
            this.accessHandler.onLabel(label);
        }

        @Override
        public void visitLdcInsn(Object value) {
            if (JavaClassDescriptorImporter.isAsmType(value)) {
                JavaClassDescriptor type = JavaClassDescriptorImporter.importAsmType(value);
                this.accessHandler.handleReferencedClassObject(type, this.actualLineNumber);
                this.declarationHandler.onDeclaredClassObject(type.getFullyQualifiedClassName());
            }
        }

        @Override
        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
            if (type != null) {
                this.accessHandler.handleTryCatchBlock(start, end, handler, JavaClassDescriptorImporter.createFromAsmObjectTypeName(type));
            } else {
                this.accessHandler.handleTryFinallyBlock(start, end, handler);
            }
        }

        @Override
        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            this.accessHandler.handleFieldInstruction(opcode, owner, name, desc);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            this.accessHandler.handleMethodInstruction(owner, name, desc);
        }

        @Override
        public void visitTypeInsn(int opcode, String type) {
            if (opcode == 193) {
                JavaClassDescriptor instanceOfCheckType = JavaClassDescriptorImporter.createFromAsmObjectTypeName(type);
                this.accessHandler.handleInstanceofCheck(instanceOfCheckType, this.actualLineNumber);
                this.declarationHandler.onDeclaredInstanceofCheck(instanceOfCheckType.getFullyQualifiedClassName());
            }
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new AnnotationProcessor(this.annotations::add, this.declarationHandler, JavaClassProcessor.handleAnnotationAnnotationProperty(desc, this.declarationHandler));
        }

        @Override
        public AnnotationVisitor visitAnnotationDefault() {
            return new AnnotationDefaultProcessor(this.declaringClassName, this.codeUnitBuilder, this.declarationHandler);
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            Object methodHandleCandidate;
            if (JavaClassDescriptorImporter.isLambdaMetafactory(bootstrapMethodHandle.getOwner()) && JavaClassDescriptorImporter.isAsmMethodHandle(methodHandleCandidate = bootstrapMethodArguments[1])) {
                this.processLambdaMetafactoryMethodHandleArgument((Handle)methodHandleCandidate);
            }
        }

        private void processLambdaMetafactoryMethodHandleArgument(Handle methodHandle) {
            if (JavaClassDescriptorImporter.isLambdaMethod(methodHandle)) {
                this.accessHandler.handleLambdaInstruction(methodHandle.getOwner(), methodHandle.getName(), methodHandle.getDesc());
            } else {
                this.accessHandler.handleMethodReferenceInstruction(methodHandle.getOwner(), methodHandle.getName(), methodHandle.getDesc());
            }
        }

        @Override
        public void visitEnd() {
            this.declarationHandler.onDeclaredMemberAnnotations(this.codeUnitBuilder.getName(), this.codeUnitBuilder.getDescriptor(), this.annotations);
            this.accessHandler.onMethodEnd();
        }

        private static class AnnotationDefaultProcessor
        extends ClassAndPrimitiveDistinguishingAnnotationVisitor {
            private final String annotationTypeName;
            private final DeclarationHandler declarationHandler;
            private final DomainBuilders.JavaMethodBuilder methodBuilder;

            AnnotationDefaultProcessor(String annotationTypeName, DomainBuilders.JavaCodeUnitBuilder<?, ?> codeUnitBuilder, DeclarationHandler declarationHandler) {
                this.annotationTypeName = annotationTypeName;
                this.declarationHandler = declarationHandler;
                Preconditions.checkArgument(codeUnitBuilder instanceof DomainBuilders.JavaMethodBuilder, "tried to import annotation defaults for code unit '%s' that is not a method (as any annotation.property() is assumed to be), this is likely a bug", (Object)codeUnitBuilder.getName());
                this.methodBuilder = (DomainBuilders.JavaMethodBuilder)codeUnitBuilder;
            }

            @Override
            void visitClass(String name, JavaClassDescriptor clazz) {
                this.declarationHandler.onDeclaredAnnotationDefaultValue(this.methodBuilder.getName(), this.methodBuilder.getDescriptor(), JavaClassProcessor.handleAnnotationClassProperty(clazz, this.declarationHandler));
                this.declarationHandler.onDeclaredAnnotationValueType(clazz.getFullyQualifiedClassName());
            }

            @Override
            void visitPrimitive(String name, Object value) {
                this.declarationHandler.onDeclaredAnnotationDefaultValue(this.methodBuilder.getName(), this.methodBuilder.getDescriptor(), DomainBuilders.JavaAnnotationBuilder.ValueBuilder.fromPrimitiveProperty(value));
            }

            @Override
            public void visitEnum(String name, String desc, String value) {
                this.declarationHandler.onDeclaredAnnotationDefaultValue(this.methodBuilder.getName(), this.methodBuilder.getDescriptor(), JavaClassProcessor.handleAnnotationEnumProperty(desc, value, this.declarationHandler));
            }

            @Override
            public AnnotationVisitor visitAnnotation(String name, String desc) {
                return new AnnotationProcessor(new SetAsAnnotationDefault(this.annotationTypeName, this.methodBuilder, this.declarationHandler), this.declarationHandler, JavaClassProcessor.handleAnnotationAnnotationProperty(desc, this.declarationHandler));
            }

            @Override
            public AnnotationVisitor visitArray(String name) {
                return new AnnotationArrayProcessor(new SetAsAnnotationDefault(this.annotationTypeName, this.methodBuilder, this.declarationHandler), this.declarationHandler);
            }
        }
    }

    private static class AnnotationProcessor
    extends ClassAndPrimitiveDistinguishingAnnotationVisitor {
        private final TakesAnnotationBuilder takesAnnotationBuilder;
        private final DeclarationHandler declarationHandler;
        private final DomainBuilders.JavaAnnotationBuilder annotationBuilder;

        private AnnotationProcessor(TakesAnnotationBuilder takesAnnotationBuilder, DeclarationHandler declarationHandler, DomainBuilders.JavaAnnotationBuilder annotationBuilder) {
            this.takesAnnotationBuilder = takesAnnotationBuilder;
            this.declarationHandler = declarationHandler;
            this.annotationBuilder = annotationBuilder;
        }

        @Override
        void visitClass(String name, JavaClassDescriptor clazz) {
            this.annotationBuilder.addProperty(name, JavaClassProcessor.handleAnnotationClassProperty(clazz, this.declarationHandler));
        }

        @Override
        void visitPrimitive(String name, Object value) {
            this.annotationBuilder.addProperty(name, DomainBuilders.JavaAnnotationBuilder.ValueBuilder.fromPrimitiveProperty(value));
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            this.annotationBuilder.addProperty(name, JavaClassProcessor.handleAnnotationEnumProperty(desc, value, this.declarationHandler));
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return new AnnotationProcessor(JavaClassProcessor.addAnnotationAsProperty(name, this.annotationBuilder), this.declarationHandler, JavaClassProcessor.handleAnnotationAnnotationProperty(desc, this.declarationHandler));
        }

        @Override
        public AnnotationVisitor visitArray(final String name) {
            return new AnnotationArrayProcessor(new AnnotationArrayContext(){

                @Override
                public String getDeclaringAnnotationTypeName() {
                    return annotationBuilder.getFullyQualifiedClassName();
                }

                @Override
                public String getDeclaringAnnotationMemberName() {
                    return name;
                }

                @Override
                public void setArrayResult(DomainBuilders.JavaAnnotationBuilder.ValueBuilder valueBuilder) {
                    annotationBuilder.addProperty(name, valueBuilder);
                }
            }, this.declarationHandler);
        }

        @Override
        public void visitEnd() {
            this.takesAnnotationBuilder.add(this.annotationBuilder);
        }
    }

    private static abstract class ClassAndPrimitiveDistinguishingAnnotationVisitor
    extends AnnotationVisitor {
        ClassAndPrimitiveDistinguishingAnnotationVisitor() {
            super(589824);
        }

        @Override
        public final void visit(String name, Object input) {
            Object value = JavaClassDescriptorImporter.importAsmTypeIfPossible(input);
            if (value instanceof JavaClassDescriptor) {
                this.visitClass(name, (JavaClassDescriptor)value);
            } else {
                this.visitPrimitive(name, value);
            }
        }

        abstract void visitClass(String var1, JavaClassDescriptor var2);

        abstract void visitPrimitive(String var1, Object var2);
    }

    private static interface AnnotationArrayContext {
        public String getDeclaringAnnotationTypeName();

        public String getDeclaringAnnotationMemberName();

        public void setArrayResult(DomainBuilders.JavaAnnotationBuilder.ValueBuilder var1);
    }

    private static class AnnotationArrayProcessor
    extends ClassAndPrimitiveDistinguishingAnnotationVisitor {
        private final AnnotationArrayContext annotationArrayContext;
        private final DeclarationHandler declarationHandler;
        private Class<?> derivedComponentType;
        private final List<DomainBuilders.JavaAnnotationBuilder.ValueBuilder> values = new ArrayList<DomainBuilders.JavaAnnotationBuilder.ValueBuilder>();

        private AnnotationArrayProcessor(AnnotationArrayContext annotationArrayContext, DeclarationHandler declarationHandler) {
            this.annotationArrayContext = annotationArrayContext;
            this.declarationHandler = declarationHandler;
        }

        @Override
        void visitClass(String name, JavaClassDescriptor clazz) {
            this.setDerivedComponentType(JavaClass.class);
            this.values.add(JavaClassProcessor.handleAnnotationClassProperty(clazz, this.declarationHandler));
        }

        @Override
        void visitPrimitive(String name, Object value) {
            this.setDerivedComponentType(value.getClass());
            this.values.add(DomainBuilders.JavaAnnotationBuilder.ValueBuilder.fromPrimitiveProperty(value));
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            this.setDerivedComponentType(JavaAnnotation.class);
            return new AnnotationProcessor(annotationBuilder -> this.values.add(DomainBuilders.JavaAnnotationBuilder.ValueBuilder.fromAnnotationProperty(annotationBuilder)), this.declarationHandler, JavaClassProcessor.handleAnnotationAnnotationProperty(desc, this.declarationHandler));
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
            this.setDerivedComponentType(JavaEnumConstant.class);
            this.values.add(JavaClassProcessor.handleAnnotationEnumProperty(desc, value, this.declarationHandler));
        }

        private void setDerivedComponentType(Class<?> type) {
            Preconditions.checkState(this.derivedComponentType == null || this.derivedComponentType.equals(type), "Found mixed component types while importing array, this is most likely a bug");
            this.derivedComponentType = type;
        }

        @Override
        public void visitEnd() {
            this.annotationArrayContext.setArrayResult(new ArrayValueBuilder());
        }

        private class ArrayValueBuilder
        extends DomainBuilders.JavaAnnotationBuilder.ValueBuilder {
            private ArrayValueBuilder() {
            }

            @Override
            public <T extends HasDescription> Optional<Object> build(T owner, ImportedClasses importContext) {
                return this.determineComponentType(importContext).map(aClass -> this.toArray((Class<?>)aClass, this.buildValues(owner, importContext)));
            }

            private Object toArray(Class<?> componentType, List<Object> values) {
                if (componentType == Boolean.TYPE) {
                    return Booleans.toArray(values);
                }
                if (componentType == Byte.TYPE) {
                    return Bytes.toArray(values);
                }
                if (componentType == Short.TYPE) {
                    return Shorts.toArray(values);
                }
                if (componentType == Integer.TYPE) {
                    return Ints.toArray(values);
                }
                if (componentType == Long.TYPE) {
                    return Longs.toArray(values);
                }
                if (componentType == Float.TYPE) {
                    return Floats.toArray(values);
                }
                if (componentType == Double.TYPE) {
                    return Doubles.toArray(values);
                }
                if (componentType == Character.TYPE) {
                    return Chars.toArray(values);
                }
                return values.toArray((Object[])Array.newInstance(componentType, values.size()));
            }

            private <T extends HasDescription> List<Object> buildValues(T owner, ImportedClasses importContext) {
                return AnnotationArrayProcessor.this.values.stream().flatMap(value -> value.build(owner, importContext).map(Stream::of).orElse(Stream.empty())).collect(Collectors.toList());
            }

            private Optional<Class<?>> determineComponentType(ImportedClasses importContext) {
                if (AnnotationArrayProcessor.this.derivedComponentType != null) {
                    return Optional.of(AnnotationArrayProcessor.this.derivedComponentType);
                }
                Optional<JavaClass> returnType = importContext.getMethodReturnType(AnnotationArrayProcessor.this.annotationArrayContext.getDeclaringAnnotationTypeName(), AnnotationArrayProcessor.this.annotationArrayContext.getDeclaringAnnotationMemberName());
                return returnType.isPresent() ? this.determineComponentTypeFromReturnValue(returnType.get()) : Optional.empty();
            }

            private Optional<Class<?>> determineComponentTypeFromReturnValue(JavaClass returnType) {
                if (returnType.isEquivalentTo(Class[].class)) {
                    return Optional.of(JavaClass.class);
                }
                return this.resolveComponentTypeFrom(returnType.getName());
            }

            @MayResolveTypesViaReflection(reason="Resolving primitives does not really use reflection")
            private Optional<Class<?>> resolveComponentTypeFrom(String arrayTypeName) {
                JavaClassDescriptor descriptor = JavaClassDescriptor.From.name(arrayTypeName);
                JavaClassDescriptor componentType = this.getComponentType(descriptor);
                if (componentType.isPrimitive()) {
                    return Optional.of(componentType.resolveClass());
                }
                if (String.class.getName().equals(componentType.getFullyQualifiedClassName())) {
                    return Optional.of(String.class);
                }
                return Optional.of(Object.class);
            }

            private JavaClassDescriptor getComponentType(JavaClassDescriptor descriptor) {
                Optional<JavaClassDescriptor> result = descriptor.tryGetComponentType();
                Preconditions.checkState(result.isPresent(), "Couldn't determine component type of array return type %s, this is most likely a bug", (Object)descriptor.getFullyQualifiedClassName());
                return result.get();
            }
        }
    }

    private static class SetAsAnnotationDefault
    implements TakesAnnotationBuilder,
    AnnotationArrayContext {
        private final String annotationTypeName;
        private final DomainBuilders.JavaMethodBuilder methodBuilder;
        private final DeclarationHandler declarationHandler;

        private SetAsAnnotationDefault(String annotationTypeName, DomainBuilders.JavaMethodBuilder methodBuilder, DeclarationHandler declarationHandler) {
            this.annotationTypeName = annotationTypeName;
            this.methodBuilder = methodBuilder;
            this.declarationHandler = declarationHandler;
        }

        @Override
        public void add(DomainBuilders.JavaAnnotationBuilder annotation) {
            this.setArrayResult(DomainBuilders.JavaAnnotationBuilder.ValueBuilder.fromAnnotationProperty(annotation));
        }

        @Override
        public String getDeclaringAnnotationTypeName() {
            return this.annotationTypeName;
        }

        @Override
        public String getDeclaringAnnotationMemberName() {
            return this.methodBuilder.getName();
        }

        @Override
        public void setArrayResult(DomainBuilders.JavaAnnotationBuilder.ValueBuilder valueBuilder) {
            this.declarationHandler.onDeclaredAnnotationDefaultValue(this.methodBuilder.getName(), this.methodBuilder.getDescriptor(), valueBuilder);
        }
    }
}

