/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.library.freeze;

import com.tngtech.archunit.ArchConfiguration;
import com.tngtech.archunit.base.MayResolveTypesViaReflection;
import com.tngtech.archunit.base.ReflectionUtils;
import com.tngtech.archunit.library.freeze.ViolationLineMatcher;
import com.tngtech.archunit.library.freeze.ViolationLineMatcherInitializationFailedException;

class ViolationLineMatcherFactory {
    private static final String FREEZE_LINE_MATCHER_PROPERTY = "freeze.lineMatcher";
    private static final ViolationLineMatcher DEFAULT_MATCHER = new FuzzyViolationLineMatcher();

    ViolationLineMatcherFactory() {
    }

    static ViolationLineMatcher create() {
        return ArchConfiguration.get().containsProperty(FREEZE_LINE_MATCHER_PROPERTY) ? ViolationLineMatcherFactory.createInstance(ArchConfiguration.get().getProperty(FREEZE_LINE_MATCHER_PROPERTY)) : DEFAULT_MATCHER;
    }

    @MayResolveTypesViaReflection(reason="This is not part of the import process")
    private static ViolationLineMatcher createInstance(String lineMatcherClassName) {
        try {
            return (ViolationLineMatcher)ReflectionUtils.newInstanceOf(Class.forName(lineMatcherClassName), new Object[0]);
        }
        catch (Exception e) {
            String message = String.format("Could not instantiate %s of configured type '%s=%s'", ViolationLineMatcher.class.getSimpleName(), FREEZE_LINE_MATCHER_PROPERTY, lineMatcherClassName);
            throw new ViolationLineMatcherInitializationFailedException(message, e);
        }
    }

    private static class FuzzyViolationLineMatcher
    implements ViolationLineMatcher {
        private FuzzyViolationLineMatcher() {
        }

        @Override
        public boolean matches(String str1, String str2) {
            RelevantPartIterator relevantPart1 = new RelevantPartIterator(str1);
            RelevantPartIterator relevantPart2 = new RelevantPartIterator(str2);
            while (relevantPart1.hasNext() && relevantPart2.hasNext()) {
                if (relevantPart1.next().equals(relevantPart2.next())) continue;
                return false;
            }
            return !relevantPart1.hasNext() && !relevantPart2.hasNext();
        }

        static class RelevantPartIterator {
            private final String str;
            private final int length;
            private int start = 0;
            private int end = -1;

            RelevantPartIterator(String str) {
                this.str = str;
                this.length = str.length();
            }

            boolean hasNext() {
                if (this.start >= this.length) {
                    return false;
                }
                if (this.end >= 0) {
                    this.start = this.findStartIndexOfNextRelevantPart();
                }
                return this.start < this.length;
            }

            public String next() {
                this.end = Math.min(this.nextIndexOfCharacterOrEndOfString(':'), this.nextIndexOfCharacterOrEndOfString('$'));
                return this.str.substring(this.start, this.end + 1);
            }

            private int nextIndexOfCharacterOrEndOfString(char ch) {
                int i = this.str.indexOf(ch, this.start);
                return i >= 0 ? i : this.length - 1;
            }

            private int findStartIndexOfNextRelevantPart() {
                int startOfIgnoredPart = this.end + 1;
                int indexOfNonDigit = this.findIndexOfNextNonDigitChar(startOfIgnoredPart);
                if (this.str.charAt(this.end) == ':') {
                    boolean foundNumber = indexOfNonDigit > startOfIgnoredPart;
                    boolean foundClosingParenthesisAfterNumber = foundNumber && indexOfNonDigit < this.length && this.str.charAt(indexOfNonDigit) == ')';
                    return foundClosingParenthesisAfterNumber ? indexOfNonDigit + 1 : startOfIgnoredPart;
                }
                return indexOfNonDigit;
            }

            private int findIndexOfNextNonDigitChar(int index) {
                while (index < this.length && Character.isDigit(this.str.charAt(index))) {
                    ++index;
                }
                return index;
            }
        }
    }
}

