/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.codeexplorer.task;

import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.importer.ImportOption;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.freeplane.features.mode.Controller;
import org.freeplane.plugin.codeexplorer.dependencies.DependencyDirection;
import org.freeplane.plugin.codeexplorer.dependencies.DependencyRule;
import org.freeplane.plugin.codeexplorer.dependencies.DependencyVerdict;
import org.freeplane.plugin.codeexplorer.task.ClassMatcher;
import org.freeplane.plugin.codeexplorer.task.ClassNameMatcher;
import org.freeplane.plugin.codeexplorer.task.CodeAttributeMatcher;
import org.freeplane.plugin.codeexplorer.task.ConfigurationChange;
import org.freeplane.plugin.codeexplorer.task.DependencyRuleJudge;
import org.freeplane.plugin.codeexplorer.task.DirectoryMatcher;
import org.freeplane.plugin.codeexplorer.task.GroupMatcher;
import org.freeplane.plugin.codeexplorer.task.LocationMatcherFactory;
import org.freeplane.plugin.codeexplorer.task.RmiMatcher;
import org.freeplane.plugin.codeexplorer.task.RmiMatcherFactory;

public class ParsedConfiguration {
    public static final String HELP;
    private static final String CLASS_PATTERN = "[\\w\\.\\|\\(\\)\\*\\[\\]]+";
    private static final String LOCATION_PATTERN = "[\\w\\.-]+(?:\\s*,\\s*[\\w\\.-]+)*";
    private static final String DIRECTION_PATTERN;
    private static final Pattern DEPENDENCY_RULE_PATTERN;
    private static final Pattern CLASSPATH_PATTERN;
    private static final Pattern IGNORED_CLASS_PATTERN;
    private static final Pattern IMPORTED_ANNOTATION_PATTERN;
    private static final Pattern GROUP_PATTERN;
    private static final Pattern LOCATION_GROUP_PATTERN;
    private static final Pattern GROUP_RMI;
    private static final Pattern IGNORED_RMI_PATTERN;
    private final List<DependencyRule> rules;
    private final ClassMatcher ignoredClasses;
    private final CodeAttributeMatcher codeAttributeMatcher;
    private final List<String> subpaths;
    private final List<ClassNameMatcher> groupMatchers;
    private final Map<String, String> locationGroups;
    private final Optional<RmiMatcher.Mode> rmiMatcherMode;
    private final ClassMatcher ignoredRmi;

    public ParsedConfiguration(String dsl) {
        ArrayList<DependencyRule> dependencyRules = new ArrayList<DependencyRule>();
        ArrayList<String> ignoredClasses = new ArrayList<String>();
        ArrayList<String> importedAnnotations = new ArrayList<String>();
        ArrayList<String> subpaths = new ArrayList<String>();
        ArrayList<ClassNameMatcher> groupMatchers = new ArrayList<ClassNameMatcher>();
        RmiMatcher.Mode rmiMatcherMode = null;
        ArrayList<String> ignoredRmi = new ArrayList<String>();
        HashMap<String, String> locationGroups = new HashMap<String, String>();
        String[] dslRules = dsl.split("\\n\\s*");
        String dslRule = "";
        for (String dslRuleLine : dslRules) {
            Object name;
            String string = dslRule.endsWith(",") ? dslRule + dslRuleLine.trim() : (dslRule = dslRule.endsWith("\\") ? dslRule.substring(0, dslRule.length() - 1) + dslRuleLine.trim() : dslRuleLine.trim());
            if (dslRule.isEmpty() || dslRule.startsWith("#") || dslRule.startsWith("//") || dslRule.endsWith(",") || dslRule.endsWith("\\")) continue;
            Matcher dependencyMatcher = DEPENDENCY_RULE_PATTERN.matcher(dslRule);
            if (dependencyMatcher.find()) {
                DependencyVerdict type = DependencyVerdict.parseVerdict(dependencyMatcher.group(1));
                String originPattern = dependencyMatcher.group(2);
                String directionNotation = dependencyMatcher.group(3);
                String targetPattern = dependencyMatcher.group(4);
                DependencyDirection dependencyDirection = DependencyDirection.parseDirection(directionNotation);
                DependencyRule rule = new DependencyRule(type, originPattern, targetPattern, dependencyDirection);
                dependencyRules.add(rule);
                continue;
            }
            Matcher classpathMatcher = CLASSPATH_PATTERN.matcher(dslRule);
            if (classpathMatcher.find()) {
                subpaths.add(classpathMatcher.group(1));
                continue;
            }
            Matcher ignoredClassMatcher = IGNORED_CLASS_PATTERN.matcher(dslRule);
            if (ignoredClassMatcher.find()) {
                ignoredClasses.add(ignoredClassMatcher.group(1));
                continue;
            }
            Matcher groupRmiMatcher = GROUP_RMI.matcher(dslRule);
            if (groupRmiMatcher.find()) {
                rmiMatcherMode = groupRmiMatcher.group(1) != null ? RmiMatcher.Mode.INSTANTIATIONS : RmiMatcher.Mode.IMPLEMENTATIONS;
                continue;
            }
            Matcher ignoredRmiMatcher = IGNORED_RMI_PATTERN.matcher(dslRule);
            if (ignoredRmiMatcher.find()) {
                ignoredRmi.add(ignoredRmiMatcher.group(1));
                continue;
            }
            Matcher groupPatternMatcher = GROUP_PATTERN.matcher(dslRule);
            if (groupPatternMatcher.find()) {
                boolean ignores = groupPatternMatcher.group(1) != null;
                boolean matchesClasses = groupPatternMatcher.group(2) != null;
                String pattern = groupPatternMatcher.group(3);
                name = Optional.ofNullable(groupPatternMatcher.group(4));
                groupMatchers.add(new ClassNameMatcher(pattern, ignores, matchesClasses, (Optional<String>)name));
                continue;
            }
            Matcher locationGroupPatternMatcher = LOCATION_GROUP_PATTERN.matcher(dslRule);
            if (locationGroupPatternMatcher.find()) {
                boolean ignores = locationGroupPatternMatcher.group(1) != null;
                String[] locations = locationGroupPatternMatcher.group(2).split("\\s*,\\s*");
                name = ignores ? "" : Optional.ofNullable(locationGroupPatternMatcher.group(3)).orElse(locations[0]);
                Arrays.asList(locations).forEach(arg_0 -> ParsedConfiguration.lambda$new$1(locationGroups, (String)name, arg_0));
                continue;
            }
            Matcher importedAnnotationMatcher = IMPORTED_ANNOTATION_PATTERN.matcher(dslRule);
            if (importedAnnotationMatcher.find()) {
                String annotationPattern = importedAnnotationMatcher.group(2);
                if (annotationPattern.endsWith("()") && importedAnnotationMatcher.group(1).equals("interface")) {
                    throw new IllegalArgumentException("Invalid rule " + dslRule);
                }
                importedAnnotations.add(annotationPattern);
                continue;
            }
            throw new IllegalArgumentException("Invalid rule " + dslRule);
        }
        this.rules = dependencyRules;
        this.ignoredClasses = new ClassMatcher(ignoredClasses);
        this.codeAttributeMatcher = new CodeAttributeMatcher(importedAnnotations);
        this.subpaths = subpaths;
        this.groupMatchers = groupMatchers;
        this.locationGroups = locationGroups;
        this.rmiMatcherMode = Optional.ofNullable(rmiMatcherMode);
        this.ignoredRmi = new ClassMatcher(ignoredRmi);
    }

    public DependencyRuleJudge judge() {
        return new DependencyRuleJudge(this.rules);
    }

    public CodeAttributeMatcher codeAttributeMatcher() {
        return this.codeAttributeMatcher;
    }

    public DirectoryMatcher createDirectoryMatcher(Collection<File> locations) {
        return new DirectoryMatcher(locations, this.subpaths, this.groupMatchers);
    }

    public ImportOption importOption() {
        return this.ignoredClasses;
    }

    public ConfigurationChange configurationChange(ParsedConfiguration previousConfiguration) {
        if (previousConfiguration == null || !this.subpaths.equals(previousConfiguration.subpaths) || !this.ignoredClasses.equals(previousConfiguration.ignoredClasses)) {
            return ConfigurationChange.CODE_BASE;
        }
        if (!this.rules.equals(previousConfiguration.rules) || !this.codeAttributeMatcher.equals(previousConfiguration.codeAttributeMatcher)) {
            return ConfigurationChange.CONFIGURATION;
        }
        if (!(this.groupMatchers.equals(previousConfiguration.groupMatchers) && this.ignoredRmi.equals(previousConfiguration.ignoredRmi) && this.rmiMatcherMode.equals(previousConfiguration.rmiMatcherMode) && this.locationGroups.equals(previousConfiguration.locationGroups))) {
            return ConfigurationChange.GROUPS;
        }
        return ConfigurationChange.SAME;
    }

    public GroupMatcher createGroupMatcher(Set<File> projectLocations, JavaClasses classes) {
        DirectoryMatcher directoryMatcher = this.createDirectoryMatcher(projectLocations);
        GroupMatcher rmiMatcher = this.rmiMatcherMode.map(mode -> new RmiMatcherFactory(directoryMatcher, classes, (RmiMatcher.Mode)((Object)mode), this.ignoredRmi).createMatcher()).orElse(directoryMatcher);
        GroupMatcher locationMatcher = this.locationGroups.isEmpty() ? rmiMatcher : new LocationMatcherFactory(rmiMatcher, classes, this.locationGroups).createMatcher();
        return locationMatcher;
    }

    private static /* synthetic */ void lambda$new$1(Map locationGroups, String name, String location) {
        locationGroups.computeIfAbsent(location, x -> name);
    }

    static {
        Controller currentController = Controller.getCurrentController();
        HELP = currentController != null ? currentController.getResourceController().loadString("/org/freeplane/plugin/codeexplorer/documentation.txt") : "";
        DIRECTION_PATTERN = Pattern.quote(DependencyDirection.UP.notation) + "|" + Pattern.quote(DependencyDirection.DOWN.notation) + "|" + Pattern.quote(DependencyDirection.ANY.notation);
        DEPENDENCY_RULE_PATTERN = Pattern.compile("^\\s*(" + DependencyVerdict.ALLOWED.keyword + "|" + DependencyVerdict.FORBIDDEN.keyword + "|" + DependencyVerdict.IGNORED.keyword + ")\\s+(" + CLASS_PATTERN + ")\\s*(" + DIRECTION_PATTERN + ")\\s*(" + CLASS_PATTERN + ")\\s*$");
        CLASSPATH_PATTERN = Pattern.compile("^\\s*classpath\\s+/*(.*\\S)\\s*$");
        IGNORED_CLASS_PATTERN = Pattern.compile("^\\s*ignore\\s+class\\s+([\\w\\.\\|\\(\\)\\*\\[\\]]+)\\s*$");
        IMPORTED_ANNOTATION_PATTERN = Pattern.compile("^\\s*import\\s+(annotation|interface)\\s+([\\w\\.\\|\\(\\)\\*\\[\\]]+)\\s*$");
        GROUP_PATTERN = Pattern.compile("^\\s*(?:(ignore)\\s+)?(?:(class)\\s+)?group\\s+([\\w\\.\\|\\(\\)\\*\\[\\]]+)(?:\\s+as\\s+(.*?))?\\s*$");
        LOCATION_GROUP_PATTERN = Pattern.compile("^\\s*(?:(ignore)\\s+)?location\\s+group\\s+([\\w\\.-]+(?:\\s*,\\s*[\\w\\.-]+)*)(?:\\s+as\\s+(.*?))?\\s*$");
        GROUP_RMI = Pattern.compile("^\\s*group\\s+(?:RMI|rmi)(\\s+instances)?\\s*$");
        IGNORED_RMI_PATTERN = Pattern.compile("^\\s*ignore\\s+(?:RMI|rmi)\\s+([\\w\\.\\|\\(\\)\\*\\[\\]]+)\\s*$");
    }
}

