/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Policy;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.knopflerfish.framework.BundleArchive;
import org.knopflerfish.framework.BundleContextImpl;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleHooks;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundleStorage;
import org.knopflerfish.framework.BundleThread;
import org.knopflerfish.framework.Bundles;
import org.knopflerfish.framework.Debug;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.FWProps;
import org.knopflerfish.framework.FileTree;
import org.knopflerfish.framework.Listeners;
import org.knopflerfish.framework.PackageAdminImpl;
import org.knopflerfish.framework.PermissionOps;
import org.knopflerfish.framework.Pkg;
import org.knopflerfish.framework.Resolver;
import org.knopflerfish.framework.ResolverHooks;
import org.knopflerfish.framework.ServiceContentHandlerFactory;
import org.knopflerfish.framework.ServiceHooks;
import org.knopflerfish.framework.ServiceURLStreamHandlerFactory;
import org.knopflerfish.framework.Services;
import org.knopflerfish.framework.StartLevelController;
import org.knopflerfish.framework.SystemBundle;
import org.knopflerfish.framework.Util;
import org.knopflerfish.framework.Validator;
import org.knopflerfish.framework.WeavingHooks;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.service.startlevel.StartLevel;

public class FrameworkContext {
    private static final String CONDITIONAL_PERMISSION_SECURITY_MANAGER = "org.knopflerfish.framework.permissions.ConditionalPermissionSecurityManager";
    private static final String KF_SECURITY_MANAGER = "org.knopflerfish.framework.permissions.KFSecurityManager";
    private static final String SECURE_PERMISSON_OPS = "org.knopflerfish.framework.SecurePermissionOps";
    public Debug debug;
    Bundles bundles;
    Listeners listeners;
    ServiceHooks serviceHooks;
    BundleHooks bundleHooks;
    ResolverHooks resolverHooks;
    WeavingHooks weavingHooks;
    Resolver resolver;
    Services services;
    PermissionOps perm;
    SystemBundle systemBundle;
    BundleStorage storage;
    List<Validator> validator = null;
    FileTree dataStorage;
    StartLevelController startLevelController;
    ServiceURLStreamHandlerFactory urlStreamHandlerFactory;
    ServiceContentHandlerFactory contentHandlerFactory;
    ArrayList<String> bootDelegationPatterns;
    boolean bootDelegationUsed;
    ClassLoader parentClassLoader;
    boolean isInit = false;
    boolean firstInit = true;
    final int id;
    int initCount = 0;
    public FWProps props;
    public ThreadGroup threadGroup;
    LinkedList<BundleThread> bundleThreads;
    PackageAdminImpl packageAdmin = null;
    String bsnversionMode;
    static volatile ServiceURLStreamHandlerFactory systemUrlStreamHandlerFactory;
    static volatile ServiceContentHandlerFactory systemContentHandlerFactory;
    static Object globalFwLock;
    static int globalId;
    static int smUse;

    static void setupURLStreamHandleFactory() {
        ServiceURLStreamHandlerFactory res = new ServiceURLStreamHandlerFactory();
        try {
            URL.setURLStreamHandlerFactory(res);
            systemUrlStreamHandlerFactory = res;
        }
        catch (Throwable e) {
            System.err.println("Cannot set global URL handlers, continuing without OSGi service URL handler (" + e + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FrameworkContext(Map<String, String> initProps) {
        Object object = globalFwLock;
        synchronized (object) {
            this.id = globalId++;
        }
        this.threadGroup = new ThreadGroup("FW#" + this.id);
        this.props = new FWProps(initProps, this);
        this.perm = new PermissionOps();
        this.systemBundle = new SystemBundle(this);
        this.log("created");
    }

    public ClassLoader getClassLoader(String clazz) {
        ExportPkg ep;
        Pkg p;
        int pos;
        if (clazz != null && (pos = clazz.lastIndexOf(46)) != -1 && (p = this.resolver.getPkg(clazz.substring(0, pos))) != null && (ep = p.getBestProvider()) != null) {
            return ep.bpkgs.bg.getClassLoader();
        }
        return this.systemBundle.getClassLoader();
    }

    void init(FrameworkListener ... initListeners) {
        this.log("initializing");
        ++this.initCount;
        this.isInit = true;
        if (this.firstInit && "onFirstInit".equals(this.props.getProperty("org.osgi.framework.storage.clean"))) {
            this.deleteFWDir();
            this.firstInit = false;
        }
        this.buildBootDelegationPatterns();
        this.selectBootDelegationParentClassLoader();
        if (this.setSecurityManager()) {
            this.systemBundle.secure = this.perm = (PermissionOps)this.doNew(SECURE_PERMISSON_OPS);
        }
        this.perm.init();
        this.listeners = new Listeners(this, this.perm, initListeners);
        String v = this.props.getProperty("org.knopflerfish.framework.validator");
        if (!v.equalsIgnoreCase("none") && !v.equalsIgnoreCase("null")) {
            this.validator = new ArrayList<Validator>();
            int start = 0;
            while (start < v.length()) {
                int end = v.indexOf(44, start);
                if (end == -1) {
                    end = v.length();
                }
                String vs = "org.knopflerfish.framework.validator." + v.substring(start, end).trim();
                this.validator.add((Validator)this.doNew(vs));
                start = end + 1;
            }
        }
        if (null == this.urlStreamHandlerFactory) {
            if (this.props.REGISTERSERVICEURLHANDLER) {
                if (systemUrlStreamHandlerFactory == null) {
                    FrameworkContext.setupURLStreamHandleFactory();
                }
                this.urlStreamHandlerFactory = systemUrlStreamHandlerFactory;
                if (systemContentHandlerFactory != null) {
                    this.contentHandlerFactory = systemContentHandlerFactory;
                } else {
                    this.contentHandlerFactory = new ServiceContentHandlerFactory(this);
                    try {
                        URLConnection.setContentHandlerFactory(this.contentHandlerFactory);
                        systemContentHandlerFactory = this.contentHandlerFactory;
                    }
                    catch (Throwable e) {
                        this.debug.printStackTrace("Cannot set global content handlers, continuing without OSGi service content handler (" + e + ")", e);
                        this.frameworkError(this.systemBundle, e, new FrameworkListener[0]);
                    }
                }
            } else {
                this.urlStreamHandlerFactory = systemUrlStreamHandlerFactory != null ? systemUrlStreamHandlerFactory : new ServiceURLStreamHandlerFactory();
                this.contentHandlerFactory = new ServiceContentHandlerFactory(this);
            }
        }
        this.props.props.put("org.osgi.framework.uuid", this.getUUID());
        String bsnProp = this.props.getProperty("org.osgi.framework.bsnversion").trim().toLowerCase();
        if (bsnProp.equals("managed") || bsnProp.equals("multiple") || bsnProp.equals("single")) {
            this.bsnversionMode = bsnProp;
        } else {
            this.bsnversionMode = "managed";
            this.debug.println("Unknown property value: org.osgi.framework.bsnversion = " + bsnProp);
        }
        String storageClass = "org.knopflerfish.framework.bundlestorage." + this.props.getProperty("org.knopflerfish.framework.bundlestorage") + ".BundleStorageImpl";
        try {
            Class<?> storageImpl = Class.forName(storageClass);
            Constructor<?> cons = storageImpl.getConstructor(FrameworkContext.class);
            this.storage = (BundleStorage)cons.newInstance(this);
        }
        catch (Exception e) {
            Throwable cause = e;
            if (e instanceof InvocationTargetException) {
                cause = ((InvocationTargetException)e).getTargetException();
            }
            RuntimeException re = new RuntimeException("Failed to initialize storage " + storageClass, cause);
            this.frameworkError(this.systemBundle, (Throwable)re, new FrameworkListener[0]);
            throw re;
        }
        this.dataStorage = this.props.getBooleanProperty("org.knopflerfish.framework.readonly") ? null : Util.getFileStorage(this, "data");
        BundleThread.checkWarnStopActionNotSupported(this);
        this.bundleThreads = new LinkedList();
        this.resolver = new Resolver(this);
        this.services = new Services(this, this.perm);
        this.urlStreamHandlerFactory.addFramework(this);
        this.serviceHooks = new ServiceHooks(this);
        this.bundleHooks = new BundleHooks(this);
        this.resolverHooks = new ResolverHooks(this);
        this.weavingHooks = new WeavingHooks(this);
        this.systemBundle.initSystemBundle();
        this.bundles = new Bundles(this);
        this.serviceHooks.open();
        this.resolverHooks.open();
        this.weavingHooks.open();
        this.perm.registerService();
        this.packageAdmin = new PackageAdminImpl(this);
        String[] classes = new String[]{PackageAdmin.class.getName()};
        this.services.register(this.systemBundle, classes, this.packageAdmin, null);
        this.registerStartLevel();
        this.bundles.load();
        this.systemBundle.extensionCallStart(null);
        this.listeners.initDone();
        this.isInit = false;
        this.log("inited");
        if (this.debug.framework) {
            BundleArchive[] allBAs;
            this.log("Installed bundles:");
            for (BundleArchive ba : allBAs = this.storage.getAllBundleArchives()) {
                Bundle b = this.bundles.getBundle(ba.getBundleLocation());
                this.log(" #" + b.getBundleId() + " " + b.getSymbolicName() + ":" + b.getVersion() + " location:" + b.getLocation());
            }
        }
    }

    private Object doNew(String clazz) {
        try {
            Class<?> n = Class.forName(clazz);
            Constructor<?> nc = n.getConstructor(FrameworkContext.class);
            return nc.newInstance(this);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException(clazz + ", constructor failed with, " + ite.getTargetException(), ite);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(clazz + ", found no such class", e);
        }
        catch (NoClassDefFoundError ncdfe) {
            throw new RuntimeException(clazz + ", class not supported by JVM", ncdfe);
        }
        catch (Exception e) {
            throw new RuntimeException(clazz + ", constructor failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void uninit() {
        this.log("uninit");
        this.startLevelController = null;
        this.systemBundle.uninitSystemBundle();
        this.resolverHooks = null;
        if (this.props.REGISTERSERVICEURLHANDLER) {
            this.urlStreamHandlerFactory.removeFramework(this);
        } else {
            this.urlStreamHandlerFactory = null;
            this.contentHandlerFactory = null;
        }
        this.bundles.clear();
        this.bundles = null;
        this.services.clear();
        this.services = null;
        this.listeners.clear();
        this.listeners = null;
        this.resolver.clear();
        this.resolver = null;
        Object object = this.bundleThreads;
        synchronized (object) {
            while (!this.bundleThreads.isEmpty()) {
                this.bundleThreads.remove(0).quit();
            }
        }
        this.bundleThreads = null;
        this.dataStorage = null;
        this.storage.close();
        this.storage = null;
        this.perm = new PermissionOps();
        object = globalFwLock;
        synchronized (object) {
            if (--smUse == 0) {
                System.setSecurityManager(null);
            }
        }
        this.parentClassLoader = null;
        this.bootDelegationPatterns = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setSecurityManager() {
        Object object = globalFwLock;
        synchronized (object) {
            SecurityManager current = System.getSecurityManager();
            String osgiSecurity = this.props.getProperty("org.osgi.framework.security");
            if (osgiSecurity.length() > 0) {
                if (!"osgi".equals(osgiSecurity)) {
                    throw new SecurityException("Unknown OSGi security, " + osgiSecurity);
                }
                if (current == null) {
                    String POLICY_PROPERTY = "java.security.policy";
                    String defaultPolicy = this.getClass().getResource("/framework.policy").toString();
                    String policy = System.getProperty("java.security.policy", defaultPolicy);
                    if (this.debug.framework) {
                        this.debug.println("Installing OSGi security manager, policy=" + policy);
                    }
                    System.setProperty("java.security.policy", policy);
                    Policy.getPolicy().refresh();
                    current = (SecurityManager)this.doNew(KF_SECURITY_MANAGER);
                    System.setSecurityManager(current);
                    smUse = 1;
                } else {
                    Class<?> cpsmc;
                    try {
                        cpsmc = Class.forName(CONDITIONAL_PERMISSION_SECURITY_MANAGER);
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeException("Missing class", e);
                    }
                    if (cpsmc.isInstance(current)) {
                        smUse = smUse == 0 ? 2 : ++smUse;
                    } else {
                        throw new SecurityException("Incompatible security manager installed");
                    }
                }
            }
            return current != null;
        }
    }

    private void deleteFWDir() {
        FileTree dir;
        String d = Util.getFrameworkDir(this);
        FileTree fileTree = dir = d != null ? new FileTree(d) : null;
        if (dir != null && dir.exists()) {
            this.log("deleting old framework directory.");
            boolean bOK = dir.delete();
            if (!bOK) {
                this.debug.println("Failed to remove existing fwdir " + dir.getAbsolutePath());
            }
        }
    }

    private String getUUID() {
        String sid = Integer.toHexString(this.id * 65536 + this.initCount);
        String baseUUID = "4e524769-3136-4b46-8000-00000000";
        return "4e524769-3136-4b46-8000-00000000".substring(0, "4e524769-3136-4b46-8000-00000000".length() - sid.length()) + sid;
    }

    private void registerStartLevel() {
        if (this.props.getBooleanProperty("org.knopflerfish.startlevel.use")) {
            if (this.debug.startlevel) {
                this.debug.println("[using startlevel service]");
            }
            this.startLevelController = new StartLevelController(this);
            String[] clsName = new String[]{StartLevel.class.getName()};
            this.services.register(this.systemBundle, clsName, this.startLevelController, null);
        }
    }

    public FileTree getDataStorage(long id) {
        if (this.dataStorage != null) {
            return new FileTree(this.dataStorage, Long.toString(id));
        }
        return null;
    }

    void checkOurBundle(Bundle b) {
        if (b == null || !(b instanceof BundleImpl) || this != ((BundleImpl)b).fwCtx) {
            throw new IllegalArgumentException("Bundle does not belong to this framework: " + b);
        }
    }

    void buildBootDelegationPatterns() {
        String bootDelegationString = this.props.getProperty("org.osgi.framework.bootdelegation");
        this.bootDelegationUsed = bootDelegationString.length() > 0;
        this.bootDelegationPatterns = new ArrayList(1);
        if (this.bootDelegationUsed) {
            try {
                for (Util.HeaderEntry he : Util.parseManifestHeader("org.osgi.framework.bootdelegation", bootDelegationString, true, true, false)) {
                    String key = he.getKey();
                    if (key.equals("*")) {
                        this.bootDelegationPatterns = null;
                        break;
                    }
                    if (key.endsWith(".*")) {
                        this.bootDelegationPatterns.add(key.substring(0, key.length() - 1));
                        continue;
                    }
                    if (key.endsWith(".")) {
                        this.frameworkError(this.systemBundle, (Throwable)new IllegalArgumentException("org.osgi.framework.bootdelegation entry ends with '.': " + key), new FrameworkListener[0]);
                        continue;
                    }
                    if (key.indexOf("*") != -1) {
                        this.frameworkError(this.systemBundle, (Throwable)new IllegalArgumentException("org.osgi.framework.bootdelegation entry contains a '*': " + key), new FrameworkListener[0]);
                        continue;
                    }
                    this.bootDelegationPatterns.add(key);
                }
            }
            catch (IllegalArgumentException e) {
                this.debug.printStackTrace("Failed to parse org.osgi.framework.bootdelegation", e);
            }
        }
    }

    boolean isBootDelegatedResource(String name) {
        int pos = name.lastIndexOf(47);
        return pos != -1 ? this.isBootDelegated(name.substring(0, pos).replace('/', '.') + ".X") : false;
    }

    boolean isBootDelegated(String className) {
        if (!this.bootDelegationUsed) {
            return false;
        }
        if (this.bootDelegationPatterns == null) {
            return true;
        }
        int pos = className.lastIndexOf(46);
        if (pos != -1) {
            String classPackage = className.substring(0, pos);
            for (String ps : this.bootDelegationPatterns) {
                if ((!ps.endsWith(".") || !classPackage.regionMatches(0, ps, 0, ps.length() - 1)) && !classPackage.equals(ps)) continue;
                return true;
            }
        }
        return false;
    }

    private void selectBootDelegationParentClassLoader() {
        String s = this.props.getProperty("org.osgi.framework.bundle.parent");
        if ("ext".equals(s)) {
            this.parentClassLoader = ClassLoader.getSystemClassLoader();
            if (this.parentClassLoader != null) {
                this.parentClassLoader = this.parentClassLoader.getParent();
            }
        } else {
            this.parentClassLoader = "app".equals(s) ? ClassLoader.getSystemClassLoader() : ("framework".equals(s) ? this.getClass().getClassLoader() : Object.class.getClassLoader());
        }
        if (this.parentClassLoader == null) {
            this.parentClassLoader = new BCLoader();
        }
    }

    public void frameworkError(Bundle b, Throwable t, FrameworkListener ... oneTimeListeners) {
        this.listeners.frameworkEvent(new FrameworkEvent(2, b, t), oneTimeListeners);
    }

    public void frameworkError(BundleContextImpl bc, Throwable t, FrameworkListener ... oneTimeListeners) {
        this.listeners.frameworkEvent(new FrameworkEvent(2, bc.bundle, t), oneTimeListeners);
    }

    public void frameworkInfo(Bundle b, Throwable t, FrameworkListener ... oneTimeListeners) {
        this.listeners.frameworkEvent(new FrameworkEvent(32, b, t), oneTimeListeners);
    }

    public void frameworkWarning(Bundle b, Throwable t, FrameworkListener ... oneTimeListeners) {
        this.listeners.frameworkEvent(new FrameworkEvent(16, b, t), oneTimeListeners);
    }

    public void frameworkWarning(BundleGeneration bg, Throwable t, FrameworkListener ... oneTimeListeners) {
        this.frameworkWarning(bg.bundle, t, oneTimeListeners);
    }

    void log(String msg) {
        if (this.debug.framework) {
            this.debug.println("Framework instance " + this.hashCode() + ": " + msg);
        }
    }

    void log(String msg, Throwable t) {
        if (this.debug.framework) {
            this.debug.printStackTrace("Framework instance " + this.hashCode() + ": " + msg, t);
        }
    }

    static {
        globalFwLock = new Object();
        globalId = 0;
        smUse = 0;
    }

    private static class BCLoader
    extends ClassLoader {
        protected BCLoader() {
            super(null);
        }
    }
}

