/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInput;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.KernSubtable;
import jogamp.graph.font.typecast.ot.table.KernSubtableFormat0;
import jogamp.graph.font.typecast.ot.table.Table;

public class KernTable
implements Table {
    private final int version;
    private final int nTables;
    private final KernSubtable[] tables;
    private final KernSubtableFormat0 table0;

    public KernTable(DataInput dataInput) throws IOException {
        this.version = dataInput.readUnsignedShort();
        this.nTables = dataInput.readUnsignedShort();
        this.tables = new KernSubtable[this.nTables];
        KernSubtableFormat0 kernSubtableFormat0 = null;
        for (int i = 0; i < this.nTables; ++i) {
            this.tables[i] = KernSubtable.read(dataInput);
            if (null != kernSubtableFormat0 || 0 != this.tables[i].getSubtableFormat()) continue;
            kernSubtableFormat0 = (KernSubtableFormat0)this.tables[i];
        }
        this.table0 = kernSubtableFormat0;
    }

    @Override
    public int getType() {
        return 1801810542;
    }

    public int getSubtableCount() {
        return this.nTables;
    }

    public KernSubtable getSubtable(int n) {
        return this.tables[n];
    }

    public KernSubtableFormat0 getSubtable0() {
        return this.table0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("'kern' Table\n--------------------------").append("\n  version:   ").append(this.version).append("\n  subtables: ").append(this.nTables);
        for (int i = 0; i < this.nTables; ++i) {
            stringBuilder.append("\n  ");
            stringBuilder.append(this.tables[i].toString());
        }
        return stringBuilder.toString();
    }
}

