/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.svg;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.LengthManager;
import io.sf.carte.echosvg.css.engine.value.ListValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import io.sf.carte.echosvg.css.engine.value.svg.SVGValueConstants;
import java.util.Locale;
import org.w3c.dom.DOMException;

public class EnableBackgroundManager
extends LengthManager {
    protected int orientation;

    @Override
    public boolean isInheritedProperty() {
        return false;
    }

    @Override
    public boolean isAnimatableProperty() {
        return false;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 23;
    }

    @Override
    public String getPropertyName() {
        return "enable-background";
    }

    @Override
    public Value getDefaultValue() {
        return SVGValueConstants.ACCUMULATE_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case IDENT: {
                String id = lu.getStringValue().toLowerCase(Locale.ROOT).intern();
                if (id == "accumulate") {
                    return SVGValueConstants.ACCUMULATE_VALUE;
                }
                if (id != "new") {
                    throw this.createInvalidIdentifierDOMException(id);
                }
                ListValue result = new ListValue(' ');
                result.append(SVGValueConstants.NEW_VALUE);
                lu = lu.getNextLexicalUnit();
                if (lu == null) {
                    return result;
                }
                result.append(super.createValue(lu, engine));
                for (int i = 1; i < 4; ++i) {
                    if ((lu = lu.getNextLexicalUnit()) == null) {
                        throw this.createMalformedLexicalUnitDOMException();
                    }
                    result.append(super.createValue(lu, engine));
                }
                return result;
            }
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
    }

    @Override
    public Value createStringValue(CSSValue.Type type, String value, CSSEngine engine) throws DOMException {
        if (type != CSSValue.Type.IDENT) {
            throw this.createInvalidStringTypeDOMException(type);
        }
        if (!value.equalsIgnoreCase("accumulate")) {
            throw this.createInvalidIdentifierDOMException(value);
        }
        return SVGValueConstants.ACCUMULATE_VALUE;
    }

    @Override
    public Value createFloatValue(short unitType, float floatValue) throws DOMException {
        throw this.createDOMException();
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        if (value.getCssValueType() == CSSValue.CssType.LIST && value.getLength() == 5) {
            Value lv1 = value.item(1);
            this.orientation = 0;
            Value v1 = super.computeValue(elt, pseudo, engine, idx, sm, lv1);
            Value lv2 = value.item(2);
            this.orientation = 1;
            Value v2 = super.computeValue(elt, pseudo, engine, idx, sm, lv2);
            Value lv3 = value.item(3);
            this.orientation = 0;
            Value v3 = super.computeValue(elt, pseudo, engine, idx, sm, lv3);
            Value lv4 = value.item(4);
            this.orientation = 1;
            Value v4 = super.computeValue(elt, pseudo, engine, idx, sm, lv4);
            if (lv1 != v1 || lv2 != v2 || lv3 != v3 || lv4 != v4) {
                ListValue result = new ListValue(' ');
                result.append(value.item(0));
                result.append(v1);
                result.append(v2);
                result.append(v3);
                result.append(v4);
                return result;
            }
        }
        return value;
    }

    @Override
    protected int getOrientation() {
        return this.orientation;
    }
}

