/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.svg;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.value.AbstractValueManager;
import io.sf.carte.echosvg.css.engine.value.RevertValue;
import io.sf.carte.echosvg.css.engine.value.URIValue;
import io.sf.carte.echosvg.css.engine.value.UnsetValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import org.w3c.dom.DOMException;

public class FilterManager
extends AbstractValueManager {
    @Override
    public boolean isInheritedProperty() {
        return false;
    }

    @Override
    public String getPropertyName() {
        return "filter";
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return false;
    }

    @Override
    public int getPropertyType() {
        return 20;
    }

    @Override
    public Value getDefaultValue() {
        return ValueConstants.NONE_VALUE;
    }

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case URI: {
                return new URIValue(lu.getStringValue(), FilterManager.resolveURI(engine.getCSSBaseURI(), lu.getStringValue()));
            }
            case IDENT: {
                if (lu.getStringValue().equalsIgnoreCase("none")) {
                    return ValueConstants.NONE_VALUE;
                }
                throw this.createInvalidIdentifierDOMException(lu.getStringValue());
            }
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case UNSET: {
                return UnsetValue.getInstance();
            }
            case REVERT: {
                return RevertValue.getInstance();
            }
            case INITIAL: {
                return this.getDefaultValue();
            }
            case VAR: {
                return this.createLexicalValue(lu);
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
    }

    @Override
    public Value createStringValue(CSSValue.Type type, String value, CSSEngine engine) throws DOMException {
        if (type == CSSValue.Type.IDENT) {
            if (value.equalsIgnoreCase("none")) {
                return ValueConstants.NONE_VALUE;
            }
            throw this.createInvalidIdentifierDOMException(value);
        }
        if (type == CSSValue.Type.URI) {
            return new URIValue(value, FilterManager.resolveURI(engine.getCSSBaseURI(), value));
        }
        throw this.createInvalidStringTypeDOMException(type);
    }
}

