/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value.svg;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.AbstractValueManager;
import io.sf.carte.echosvg.css.engine.value.CSSProxyValueException;
import io.sf.carte.echosvg.css.engine.value.CalcValue;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.NumericDelegateValue;
import io.sf.carte.echosvg.css.engine.value.RevertValue;
import io.sf.carte.echosvg.css.engine.value.UnsetValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueConstants;
import io.sf.carte.echosvg.css.engine.value.svg.SVGValueConstants;
import org.w3c.dom.DOMException;

public class OpacityManager
extends AbstractValueManager {
    protected boolean inherited;
    protected String property;

    public OpacityManager(String prop, boolean inherit) {
        this.property = prop;
        this.inherited = inherit;
    }

    @Override
    public boolean isInheritedProperty() {
        return this.inherited;
    }

    @Override
    public boolean isAnimatableProperty() {
        return true;
    }

    @Override
    public boolean isAdditiveProperty() {
        return true;
    }

    @Override
    public int getPropertyType() {
        return 25;
    }

    @Override
    public String getPropertyName() {
        return this.property;
    }

    @Override
    public Value getDefaultValue() {
        return SVGValueConstants.NUMBER_1;
    }

    @Override
    public Value createValue(LexicalUnit lu, CSSEngine engine) throws DOMException {
        switch (lu.getLexicalUnitType()) {
            case INTEGER: {
                return new FloatValue(0, lu.getIntegerValue());
            }
            case REAL: {
                return new FloatValue(0, lu.getFloatValue());
            }
            case INHERIT: {
                return ValueConstants.INHERIT_VALUE;
            }
            case UNSET: {
                return UnsetValue.getInstance();
            }
            case REVERT: {
                return RevertValue.getInstance();
            }
            case INITIAL: {
                return this.getDefaultValue();
            }
            case VAR: 
            case ATTR: {
                return this.createLexicalValue(lu);
            }
            case CALC: {
                Value calc = this.createCalc(lu);
                if (calc.getCssValueType() == CSSValue.CssType.PROXY) {
                    throw new CSSProxyValueException();
                }
                if (calc.getPrimitiveType() != CSSValue.Type.EXPRESSION) break;
                return ((CalcValue)calc).evaluate(null, null, engine, -1, null, (short)0);
            }
            case MATH_FUNCTION: {
                Value v;
                try {
                    v = this.createMathFunction(lu, "<number>");
                }
                catch (Exception e) {
                    DOMException ife = this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
                    ife.initCause(e);
                    throw ife;
                }
                return ((NumericDelegateValue)v).evaluate(null, null, engine, -1, null, (short)0);
            }
        }
        throw this.createInvalidLexicalUnitDOMException(lu.getLexicalUnitType());
    }

    @Override
    public Value createFloatValue(short type, float floatValue) throws DOMException {
        if (type == 0) {
            return new FloatValue(type, floatValue);
        }
        throw this.createInvalidFloatTypeDOMException(type);
    }

    @Override
    public Value computeValue(CSSStylableElement elt, String pseudo, CSSEngine engine, int idx, StyleMap sm, Value value) {
        return value;
    }
}

